
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstien
;;;; and Kamal Ali.  

(in-package :user)

(defvar *PAUSE-BOX* nil)

;;;____________________________________________________________________________________
;;; pause-box
;;;
;;;  Displays *PAUSE-BOX* if *PAUSE-BOX* is nil a new one is created and displayed

(defun pause-box ()
  (setf *backtrace-on-break* nil)
  (unless (ask *PAUSE-BOX* (ownp 'wptr))
    (setf *PAUSE-BOX* (oneof *dialog*
                             :window-position :centered
                             :window-title "PAUSE"
                             :window-type :document
                             :window-size #@(105 40)
                             :window-show nil))
    (ask *PAUSE-BOX* (have 'paused 0))
    (ask *PAUSE-BOX* (have 'window-do-first-click t))
    (ask *PAUSE-BOX* (add-dialog-items
                      (oneof *button-dialog-item*
                             :dialog-item-text " Break "
                             :dialog-item-nick-name :button
                             :dialog-item-position  #@(20 10)
                             :dialog-item-size #@(65 20)
                             :default-button t
                             :dialog-item-enabled-p t
                             :dialog-item-action 
                             #'(lambda ()
                                 (if (= 0 (ask *PAUSE-BOX* (objvar paused)))
                                   (pause-break)
                                   (pause-continue)))
                             ))))
  (ask *PAUSE-BOX* (window-select)))


;;;____________________________________________________________________________________
;;; pause-break

(defun pause-break ()
  (pause-box)                            ;; make sure it hasn't been closed or hidden
  (ask *PAUSE-BOX*
    (setf (objvar paused) (incf (objvar paused)))
    (ask-named-item :button (set-dialog-item-text " Continue ")))
  (break))

;;;____________________________________________________________________________________
;;; soft-pause-break

(defun soft-pause-break ()
  (ask *PAUSE-BOX*
    (when (ownp 'wptr)
      (window-select)
      (setf (objvar paused) (incf (objvar paused)))
      (ask-named-item :button (set-dialog-item-text " Continue "))
      (break))))


;;;____________________________________________________________________________________
;;; pause-continue

(defun pause-continue ()
  (ask *PAUSE-BOX*
    (when (ownp 'wptr)
      (setf (objvar paused) (max 0 (decf (objvar paused))))
      (if (= 0 (objvar paused))
        (ask-named-item :button (set-dialog-item-text " Break ")))))
  (continue))


(provide :pause)

