(in-package :CCL)

;(require 'traps)

;;____________________________________________________________________________________
;; PICT scrap handler

(defconstant $ApplScratch  #xA78)

(defclass PICT-scrap-handler (scrap-handler) ())

(defmethod get-internal-scrap ((handler PICT-scrap-handler))
  (slot-value handler 'INTERNAL-SCRAP))

(defmethod set-internal-scrap ((handler PICT-scrap-handler) value)
  (let ((old-pict (slot-value handler 'INTERNAL-SCRAP)))
    (when (handlep old-pict)
      (_KillPicture :ptr old-pict)))
  (when value
    (call-next-method)))

(defmethod internalize-scrap ((handler PICT-scrap-handler))
  (let ((the-pict (_NewHandle :d0 0 :a0)))
    (_GetScrap :ptr the-pict
               :ostype :pict
               :long $ApplScratch)
    (setf (slot-value handler 'INTERNAL-SCRAP) the-pict)))

(defmethod externalize-scrap ((handler PICT-scrap-handler))
  (let* ((the-pict (slot-value handler 'INTERNAL-SCRAP))
         (size (_GetHandleSize :a0 the-pict :d0)))
    (when the-pict
      (with-dereferenced-handles
        ((the-pict the-pict))
        (_PutScrap :long size :ostype :pict :ptr the-pict)))))

(unless (member :PICT *scrap-handler-alist* :key #'car)
  (push (cons :PICT (make-instance 'PICT-scrap-handler)) *scrap-handler-alist*))

(provide :PICT-scrap)