
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstein
;;;; and Kamal Ali.  

;;mean-file(file n selectors out-file)
#|
reads first s-exp of file.
assumes format
key1 key2 .. keyn  value1 value2 ... value j
...

generates a file of the form
key1 key2 .. keyn mean1 mean2 ... meanj
...
if selectors is provided, it creates a subset such that
each selector appears in every element.  Useful for picking
out some lines to graph, analyze etc.
Right now, its unordered, so a selector applies to any field.
(dolist (n '(50 75)) (mean-file "op3.out" 4 `(info leaves ,n))
	  (mean-file "op3.out" 4 `(info frontier ,n))
	  (mean-file "op3.out" 4 `(ratio leaves ,n)))
|#
(defun mean-file(file n &optional (selectors nil)
		      (out (format nil "~a.mean~{-~a~}" file selectors)))
  (let ((table (make-hash-table :test #'equal))
	(i 0) key)
    (with-open-file (s file)
		    
		    (do ((l (read-line s nil :eof)
			    (read-line s nil :eof)))
			((eq l :eof ))
			(setq l (read-from-string (format nil "(~A)" l)))
			(when l
			      (setq key (butlast l (- (length l) n)))
			      (when (null (set-difference selectors key))
				    (setq key (set-difference key selectors))
			      (push (nthcdr n l)
				    (gethash key
					     table))))))
    (with-open-file(s out :direction :output)
		   (maphash #'(lambda(key value)
				(setq value (mean-list value))
				(format s "~a" (incf i))
				(mapc #'(lambda(v)
					  (format s "~a~a" #\tab v)
					  )
				      key)
				(mapc #'(lambda(v)
					  (format s "~a~5f~a~5F" #\tab (car v) #\tab (cdr v))
					  )
				      value)
				(TERPRI S))
			    table))))



(defun ci-list(list &aux (l (length list)))
  (mapcar #'(lambda(x)(/ x l))
	  (reduce #'(lambda(x y)
		      (mapcar #'+ x y))
		  list
		  :initial-value (make-list (length (car list)) :initial-element 0))))
				
						  
	       
	
(defun confidence(lis)(* 1.96 (standard-error lis)))
(defun square(x)(* x x))
(defun mean(lis)
       (/ (apply '+ lis) (float(length lis))))

(defun variance(lis &optional (mean (mean lis))
                    )
  (/ (apply #'+ (mapcar #'(lambda(x)(square (- x mean))) lis))
     (float (- (length lis) 1))))

(defun standard-error(lis)
  (sqrt (/ (variance lis) (length lis))))

(defun mean-list(list &aux (l (length (car list))) (result nil) x)
  (dotimes (i l)
	  (setq x (mapcar #'(lambda(e)(nth i e)) list))
	  (push (cons (mean x)(confidence x)) result))
  (nreverse result))