
;;;; Copyright (c) 1990, 1991 by the University of California, Irvine. 
;;;; This program may be freely copied, used, or modified provided that this
;;;; copyright notice is included in each copy of this code.  This program
;;;; may not be sold or incorporated into another product to be sold withou
;;;; written permission from the Regents of the University of California.
;;;; This program was written by Michael Pazzani, Cliff Brunk, Glenn Silverstein
;;;; and Kamal Ali.  

(in-package :user)
;;; info gain computed only for last element of cliche via find-maximum-literal and 
;;; find-literal-builtin
#|
(defmacro expand-last-cliche-pred (find-literal-call)
  `(multiple-value-bind
     (pred-with-max-gain 
      varzn-with-max-gain 
      pred-max-negated? 
      pred-max-gain 
      covered-all-pos-tuples)
     ,find-literal-call
     (if (and pred-with-max-gain 
              (not (eql pred-with-max-gain :fail))
              (>= pred-max-gain max-gain))
       (setq overall-pred-with-max-gain pred-with-max-gain
             overall-varzn-with-max-gain varzn-with-max-gain
             max-negated? pred-max-negated?
             max-gain pred-max-gain))))
|#


(defmacro process-variabilizations (var-restr pred maximum-new-vars variables
                                    variable-types original-vars predicate-being-learned
                                    instantiated-cliche position-in-cliche
                                    variabilization &rest body)
  `(do* ((variabilizations 
          (apply-variabilization-restrictions 
           ,pred
           ,var-restr
           (get-variabilizations ,pred ,maximum-new-vars ,variables 
                                 ,predicate-being-learned ,variable-types ,original-vars)
           ,variables
           ,variable-types
           ,original-vars
           (r-type ,predicate-being-learned) 
           ,instantiated-cliche
           ,position-in-cliche)
          (cdr variabilizations))
         (current-struct (car variabilizations) (car variabilizations)))
        
        ((null variabilizations))  ;exit when no more variabilizations              
     (setq ,variabilization (variabilization-struct-variabilization current-struct))
     ,@body))

(defmacro push-last (e l)
  `(setf ,l (nconc ,l (list ,e))))

(defmacro push-list (l1 l2)
  `(progn
     (setf ,l2 (nconc ,l1 ,l2))
     (setf ,l1 nil)
     ,l2))
