;;; -*- Mode:Common-Lisp; Package:user; Base:10 -*-

;;; The following 50 patient cases are provided courtesy of Dr. Stanley Tuhrim
;;; of Mount Sinai School of Medicine, New York, and Dr. James Reggia of
;;; the University of Maryland at College Park. Their assistance is 
;;; gratefully acknowledged.

(in-package :user)

; 50 patient test cases

; template

(setf *p0*
      '((decloc-degree)
        (disoriented-degree)
        (dyspraxia)
        (hemineglect-side)
        (denial)
        (compdef-severity)
        (nonfluency-severity)
        (repetition-severity)
        (anomia-severity)
        (cogabn)
        (vf-deficit-side-type)
        (poorokn-direction)
        (nystagmus-type)
        (abnpupils-side-type)
        (prd-side)
        (abneom-type)
        (ptosis-side)
        (facenumb-side)
        (facial-side-type)
        (swallow-severity)
        (gag-severity)
        (tongweak-side)
        (dysarthria-severity)
        (weakness-type)
        (ataxia-type)
        (decram-side)
        (abndtrs-side)
        (babs-side)
        (gait-type)
;       (sensedef)
        (dss-side)
        (pp-side)
        (touch-side)
        (temp-side)
        (posloss-side)
        (vibloss-side)
        (twopoint-side)
        (agraph-side)))

(setf *p1*
      '((disoriented-degree mild)
        (compdef-severity mild)
        (nonfluency-severity mild)        
        (facial-side-type right-central)))

(setf *a1*
      '((left-frontal-lobe present)))

(setf *p2*
      '((disoriented-degree moderate)
        (vf-deficit-side-type left-hemianopsia)
        (poorokn-direction lhoriz)
        (abneom-type hgaze-left)
        (facenumb-side left)
        (facial-side-type left-central)
        (dysarthria-severity moderate)
        (weakness-type hemiparesis-left)
        (abndtrs-side left-decdtr)
        (babs-side left)
        (pp-side left-mild)))

(setf *a2*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)))

(setf *p3*
      '((dyspraxia present)
        (hemineglect-side right)
        (compdef-severity severe)
        (nonfluency-severity severe)
        (repetition-severity severe)
        (anomia-severity severe)
        (vf-deficit-side-type right-hemianopsia)
        (weakness-type hemiparesis-right)
        (decram-side right-mild)))

(setf *a3*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)))

(setf *p4*
      '((abneom-type hgaze-right)
        (facial-side-type right-central)
        (dysarthria-severity moderate)
        (weakness-type hemiparesis-right)
        (abndtrs-side right-incdtr)))

(setf *a4*
      '((left-frontal-lobe present)
	(left-internal-capsule present)))

(setf *p5*
      '((decloc-degree drowsy)
        (hemineglect-side left)
        (denial present)
        (vf-deficit-side-type left-hemianopsia)
        (abneom-type hgaze-left)
        (facenumb-side left)
        (facial-side-type left-central)
        (dysarthria-severity mild)
        (weakness-type hemiparesis-left)
        (abndtrs-side left-incdtr)
        (dss-side left)
        (pp-side left-severe)
        (posloss-side left)
        (vibloss-side left)
        (twopoint-side left)
        (agraph-side left)))

(setf *a5*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)
	(right-temporal-lobe present)))

(setf *p6*
      '((hemineglect-side left)
        (vf-deficit-side-type left-hemianopsia)
        (facial-side-type left-central)
        (weakness-type hemiparesis-left)
        (decram-side left-mild)
        (abndtrs-side left-decdtr)
        (dss-side left)
        (posloss-side left)))

(setf *a6*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)))

(setf *p7*
      '((decloc-degree stupor)
        (abneom-type hgaze-left)
        (facenumb-side left)
        (facial-side-type left-central)
        (dysarthria-severity severe)
        (weakness-type hemiparesis-left)
        (abndtrs-side left-incdtr)
        (babs-side left)
        (pp-side left-moderate)))

(setf *a7*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)
	(right-temporal-lobe present)))

(setf *p8*
      '((facenumb-side right)
        (weakness-type hemiparesis-right)
        (decram-side right-mild)
        (abndtrs-side right-incdtr)
        (babs-side right)
        (gait-type other)
        (pp-side right-mild)
        (vibloss-side right)))

(setf *a8*
      '((left-internal-capsule present)))

(setf *p9*
      '((vf-deficit-side-type left-hemianopsia)
        (dss-side left)))

(setf *a9*
      '((right-parietal-lobe present)
	(right-occipital-lobe present)))

(setf *p10*
      '((decloc-degree drowsy)
        (abneom-type hgaze-right)
        (facial-side-type right-central)
        (weakness-type hemiparesis-right)
        (decram-side right-mild)
        (abndtrs-side right-incdtr)
        (babs-side right)))

(setf *a10*
      '((left-frontal-lobe present)))

(setf *p11*
      '((decloc-degree drowsy)
        (disoriented-degree moderate)
        (hemineglect-side right)
        (abneom-type hgaze-right)
        (facenumb-side right)
        (dysarthria-severity moderate)
        (weakness-type hemiparesis-right)
        (abndtrs-side right-incdtr)
        (babs-side right)
        (pp-side right-mild)))

(setf *a11*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)
	(left-temporal-lobe present)))

(setf *p12*
      '((weakness-type hemiparesis-left)
        (abndtrs-side left-incdtr)
        (babs-side left)))

(setf *a12*
      '((right-internal-capsule present)))

(setf *p13*
      '((decloc-degree drowsy)
        (disoriented-degree severe)
        (hemineglect-side left)
        (denial present)
        (vf-deficit-side-type left-hemianopsia)
        (abneom-type hgaze-left)
        (facenumb-side left)
        (facial-side-type left-central)
        (weakness-type hemiparesis-left)
        (abndtrs-side left-incdtr)
        (babs-side left)
        (pp-side left-mild)))

(setf *a13*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)
	(right-temporal-lobe present)))

(setf *p14*
      '((decloc-degree drowsy)
        (disoriented-degree mild)
        (hemineglect-side left)
        (denial present)
        (vf-deficit-side-type left-hemianopsia)
        (abneom-type hgaze-left)
        (facial-side-type left-central)
        (dysarthria-severity mild)
        (weakness-type hemiparesis-left)
        (abndtrs-side left-incdtr)
        (babs-side left)
        (dss-side left)
        (posloss-side left)
        (vibloss-side left)
        (twopoint-side left)
        (agraph-side left)))

(setf *a14*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)
	(right-temporal-lobe present)))

(setf *p15*
      '((decloc-degree drowsy)
        (nystagmus-type vertical-upbeat)
        (abneom-type hgaze-left)
        (abneom-type vgaze-up)
        (abneom-type vgaze-down)
        (abneom-type ino-left)
        (facial-side-type right-central)
        (tongweak-side right)
        (dysarthria-severity mild)
        (weakness-type hemiparesis-right)
        (babs-side right)))

(setf *a15*
      '((left-pons present)))

(setf *p16*
      '((poorokn-direction lhoriz)
        (facial-side-type left-central)
        (dysarthria-severity mild)
        (weakness-type hemiparesis-left)
        (decram-side left-mild)
        (abndtrs-side left-incdtr)))

(setf *a16*
      '((right-frontal-lobe present)))

(setf *p17*
      '((facial-side-type right-central)
        (tongweak-side right)
        (dysarthria-severity moderate)
        (weakness-type hemiparesis-right)
        (abndtrs-side right-incdtr)))

(setf *a17*
      '((left-frontal-lobe present)))

(setf *p18*
      '((decloc-degree drowsy)
        (abneom-type hgaze-left)
        (facenumb-side left)
        (facial-side-type left-central)
        (weakness-type hemiparesis-left)
        (abndtrs-side left-decdtr)
        (babs-side left)
        (dss-side left)
        (pp-side left-mild)
        (posloss-side left)
        (vibloss-side left)))

(setf *a18*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)))

(setf *p19*
      '((decloc-degree stupor)
        (vf-deficit-side-type right-hemianopsia)
        (abneom-type hgaze-right)
        (facenumb-side right)
        (facial-side-type right-central)
        (weakness-type hemiparesis-right)
        (abndtrs-side right-incdtr)
        (babs-side right)
        (pp-side right-moderate)))

(setf *a19*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)
	(left-temporal-lobe present)))

(setf *p20*
      '((poorokn-direction lhoriz)
        (facial-side-type left-central)
        (weakness-type hemiparesis-left)
        (babs-side left)
        (dss-side left)))

(setf *a20*
      '((right-frontal-lobe present)))

(setf *p21*
      '((disoriented-degree mild)
        (poorokn-direction rhoriz)
        (abneom-type hgaze-right)
        (facial-side-type right-central)
        (tongweak-side right)
        (weakness-type hemiparesis-right)
        (babs-side right)))

(setf *a21*
      '((left-frontal-lobe present)))

(setf *p22*
      '((disoriented-degree mild)
        (facenumb-side left)
        (facial-side-type left-central)
        (dysarthria-severity mild)
        (weakness-type hemiparesis-left)
        (babs-side left)
        (pp-side left-moderate)
        (posloss-side left)
        (vibloss-side left)
        (twopoint-side left)
        (agraph-side left)))

(setf *a22*
      '((right-frontal-lobe present)
	(right-internal-capsule present)
	(right-thalamus present)))

(setf *p23*
      '((decloc-degree drowsy)
        (disoriented-degree mild)
        (vf-deficit-side-type left-hemianopsia)
        (poorokn-direction lhoriz)
        (abneom-type hgaze-left)
        (facenumb-side left)
        (facial-side-type left-central)
        (weakness-type hemiparesis-left)
        (abndtrs-side left-decdtr)
        (dss-side left)
        (pp-side left-moderate)
        (posloss-side left)
        (agraph-side left)))

(setf *a23*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)))

(setf *p24*
      '((compdef-severity severe)
        (nonfluency-severity severe)
        (repetition-severity severe)
        (anomia-severity severe)
        (facial-side-type right-central)))

(setf *a24*
      '((left-frontal-lobe present)
	(left-temporal-lobe present)))

(setf *p25*
      '((decloc-degree drowsy)
        (vf-deficit-side-type left-hemianopsia)
        (abneom-type hgaze-left)
        (facenumb-side left)
        (facial-side-type left-central)
        (dysarthria-severity moderate)
        (weakness-type hemiparesis-left)
        (dss-side left)
        (pp-side left-mild)
        (posloss-side left)
        (vibloss-side left)
        (twopoint-side left)
        (agraph-side left)))

(setf *a25*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)
	(right-temporal-lobe present)))

(setf *p26*
      '((facial-side-type right-central)
        (dysarthria-severity moderate)
        (weakness-type hemiparesis-right)
        (babs-side right)))

(setf *a26*
      '((left-internal-capsule present)))

(setf *p27*
      '((disoriented-degree moderate)
        (compdef-severity severe)
        (nonfluency-severity severe)
        (repetition-severity severe)
        (anomia-severity severe)
        (vf-deficit-side-type right-hemianopsia)
        (poorokn-direction rhoriz)
        (facial-side-type right-central)
        (dysarthria-severity severe)
        (weakness-type hemiparesis-right)
        (decram-side right-severe)
        (abndtrs-side right-incdtr)))

(setf *a27*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)
	(left-temporal-lobe present)))

(setf *p28*
      '((facenumb-side right)
        (weakness-type hemiparesis-right)
        (ataxia-type limb-right-mild)
        (decram-side right-mild)
        (babs-side right)
        (gait-type unsteady)))

(setf *a28*
      '((left-pons present)))

(setf *p29*
      '((nonfluency-severity mild)
        (repetition-severity mild)))

(setf *a29*
      '((left-frontal-lobe present)))

(setf *p30*
      '((disoriented-degree mild)
        (nonfluency-severity mild)
        (repetition-severity mild)
        (anomia-severity mild)
        (weakness-type hemiparesis-right)
        (decram-side right-mild)
        (babs-side right)
        (vibloss-side right)))

(setf *a30*
      '((left-internal-capsule present)
	(left-thalamus present)))

(setf *p31*
      '((facial-side-type right-central)
        (dysarthria-severity mild)
        (weakness-type hemiparesis-right)
        (decram-side right-mild)
        (babs-side right)))

(setf *a31*
      '((left-internal-capsule present)))

(setf *p32*
      '((facial-side-type right-central)
        (dysarthria-severity moderate)
        (weakness-type hemiparesis-right)
        (babs-side right)))

(setf *a32*
      '((left-internal-capsule present)))

(setf *p33*
      '((decloc-degree drowsy)
        (denial present)
        (vf-deficit-side-type left-hemianopsia)
        (facial-side-type left-central)
        (dysarthria-severity moderate)
        (weakness-type hemiparesis-left)
        (decram-side left-mild)
        (abndtrs-side left-incdtr)
        (babs-side left)))

(setf *a33*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)))

(setf *p34*
      '((abneom-type fourn-right)
        (ataxia-type limb-left-mild)
        (decram-side left-mild)
        (babs-side left)))

(setf *a34*
      '((right-midbrain present)))

(setf *p35*
      '((dyspraxia present)
        (compdef-severity severe)
        (nonfluency-severity severe)
        (repetition-severity severe)
        (anomia-severity severe)
        (vf-deficit-side-type right-hemianopsia)
        (poorokn-direction rhoriz)
        (facial-side-type right-central)
        (dysarthria-severity severe)
        (weakness-type hemiparesis-right)
        (abndtrs-side right-incdtr)
        (babs-side right)))

(setf *a35*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)
	(left-temporal-lobe present)))

(setf *p36*
      '((decloc-degree drowsy)
        (disoriented-degree severe)
        (compdef-severity severe)
        (nonfluency-severity severe)
        (repetition-severity severe)
        (anomia-severity severe)
        (vf-deficit-side-type right-hemianopsia)
        (facial-side-type right-central)
        (dysarthria-severity mild)
        (weakness-type hemiparesis-right)))

(setf *a36*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)
	(left-temporal-lobe present)))

(setf *p37*
      '((facenumb-side right)
        (facial-side-type right-central)
        (dysarthria-severity mild)
        (weakness-type hemiparesis-right)
        (ataxia-type limb-left-mild)
        (decram-side left-mild)
        (babs-side right)
        (pp-side right-mild)
        (posloss-side right)))

(setf *a37*
      '((left-pons present)))

(setf *p38*
      '((disoriented-degree moderate)
        (hemineglect-side right)
        (denial present)
        (compdef-severity moderate)
        (nonfluency-severity moderate)
        (repetition-severity moderate)
        (anomia-severity mild)
        (vf-deficit-side-type right-hemianopsia)
        (poorokn-direction rhoriz)
        (abneom-type hgaze-right)
        (facial-side-type right-central)
        (weakness-type hemiparesis-right)
        (abndtrs-side right-incdtr)
        (babs-side right)
        (dss-side right)
        (pp-side right-moderate)
        (vibloss-side right)
        (agraph-side right)))

(setf *a38*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)
	(left-temporal-lobe present)))

(setf *p39*
      '((decloc-degree drowsy)
        (disoriented-degree moderate)
        (denial present)
        (vf-deficit-side-type left-hemianopsia)
        (abneom-type hgaze-left)
        (facenumb-side left)
        (facial-side-type left-central)
        (dysarthria-severity mild)
        (weakness-type hemiparesis-left)
        (abndtrs-side left-incdtr)
        (babs-side left)
        (dss-side left)
        (pp-side left-moderate)))

(setf *a39*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)
	(right-temporal-lobe present)))

(setf *p40*
      '((facial-side-type right-central)
        (dysarthria-severity mild)
        (weakness-type hemiparesis-right)
        (babs-side right)))

(setf *a40*
      '((left-internal-capsule present)))

(setf *p41*
      '((poorokn-direction lhoriz)
        (facial-side-type left-central)
        (weakness-type hemiparesis-left)
        (decram-side left-severe)))

(setf *a41*
      '((right-internal-capsule present)))

(setf *p42*
      '((decloc-degree drowsy)
        (compdef-severity severe)
        (nonfluency-severity severe)
        (repetition-severity severe)
        (anomia-severity severe)
        (vf-deficit-side-type right-hemianopsia)
        (abneom-type hgaze-right)
        (facenumb-side right)
        (facial-side-type right-central)
        (weakness-type hemiparesis-right)
        (abndtrs-side right-decdtr)
        (pp-side right-severe)))

(setf *a42*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)
	(left-temporal-lobe present)))

(setf *p43*
      '((decloc-degree drowsy)
        (hemineglect-side right)
        (compdef-severity severe)
        (nonfluency-severity severe)
        (repetition-severity severe)
        (anomia-severity severe)
        (vf-deficit-side-type right-hemianopsia)
        (abneom-type hgaze-right)
        (facenumb-side right)
        (facial-side-type right-central)
        (dysarthria-severity severe)
        (weakness-type hemiparesis-right)
        (abndtrs-side right-incdtr)
        (babs-side right)
        (pp-side right-mild)))

(setf *a43*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)
	(left-temporal-lobe present)))

(setf *p44*
      '((facial-side-type left-central)
        (weakness-type hemiparesis-left)
        (decram-side left-mild)))

(setf *a44*
      '((right-internal-capsule present)))

(setf *p45*
      '((compdef-severity severe)
        (nonfluency-severity severe)
        (repetition-severity severe)
        (anomia-severity severe)
        (facial-side-type right-central)
        (weakness-type hemiparesis-right)))

(setf *a45*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)
	(left-temporal-lobe present)))

(setf *p46*
      '((dyspraxia present)
        (hemineglect-side right)
        (compdef-severity mild)
        (nonfluency-severity severe)
        (repetition-severity severe)
        (anomia-severity severe)
        (vf-deficit-side-type right-hemianopsia)
        (poorokn-direction rhoriz)
        (abneom-type hgaze-right)
        (facenumb-side right)
        (facial-side-type right-central)
        (dysarthria-severity moderate)
        (weakness-type hemiparesis-right)
        (abndtrs-side right-incdtr)
        (babs-side right)
        (dss-side right)
        (pp-side right-mild)))

(setf *a46*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)
	(left-temporal-lobe present)))

(setf *p47*
      '((decloc-degree drowsy)
        (compdef-severity severe)
        (nonfluency-severity severe)
        (repetition-severity severe)
        (anomia-severity severe)
        (vf-deficit-side-type right-hemianopsia)
        (abneom-type hgaze-right)
        (facenumb-side right)
        (facial-side-type right-central)
        (dysarthria-severity severe)
        (weakness-type hemiparesis-right)
        (abndtrs-side right-incdtr)
        (babs-side right)
        (pp-side right-moderate)))

(setf *a47*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)
	(left-temporal-lobe present)))

(setf *p48*
      '((ataxia-type limb-right-mild)
        (decram-side right-mild)
        (gait-type unsteady)))

(setf *a48*
      '((right-cerebellar-hemisphere present)))

(setf *p49*
      '((compdef-severity mild)
        (nonfluency-severity mild)
        (repetition-severity mild)
        (dysarthria-severity mild)
        (weakness-type hemiparesis-left)
        (decram-side left-mild)
        (dss-side left)
        (pp-side left-mild)))

(setf *a49*
      '((right-frontal-lobe present)
	(right-parietal-lobe present)))

(setf *p50*
      '((nonfluency-severity mild)
        (facenumb-side right)
        (facial-side-type right-central)
        (dysarthria-severity moderate)
        (weakness-type hemiparesis-right)
        (ataxia-type limb-right-mild)
        (decram-side right-mild)
        (abndtrs-side right-incdtr)
        (babs-side right)
        (pp-side right-mild)))

(setf *a50*
      '((left-frontal-lobe present)
	(left-parietal-lobe present)))
