// mower.cpp

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


#include "terminal.hpp"
#include "function.hpp"
#include "gene.hpp"

#include "lawn.hpp"
#include "mower.hpp"

extern Vector (* Translate)( Gene* );    // Translate defined in lawn.cpp

// subordinate code declarations
Vector ZeroVector();   //ensuring closure of the system for MOW, LEFT


// adds two vectors together modulus 8 with each component
Vector V8A( Gene *pg )
{
	Vector vInput1, vInput2, vOutput;

	vInput1 = Translate( pg );
	vInput2 = Translate( pg->pgNext );

	vOutput.i = (vInput1.i + vInput2.i) % 8;
	vOutput.j = (vInput1.j + vInput2.j) % 8;

	return vOutput;
}

// move from the current position to one which is the addition of new arg
// and return the value which is to be moved....
Vector FROG( Gene *pg )
{

	if ( Mower.Energy == 0 )  return ZeroVector();
	else
	{
		Mower.Energy--;
		Vector vInput = Translate( pg );

		if ( Mower.Moving & 2 ) // if it is odd value 1,3 it is north south
		{
			if ( Mower.Moving == 1 )   // NORTH
			{
				Mower.x = (Mower.x + (8 - vInput.i) );
				Mower.y = (Mower.y + vInput.j);
			}
			else                         // South
			{
				Mower.x = (Mower.x + vInput.i);
				Mower.y = (Mower.y + vInput.j);
			}
		}
		else
		{
			if ( Mower.Moving == 0 )  // EAST
			{
				Mower.x = (Mower.x + vInput.j);
				Mower.y = (Mower.y + vInput.i);
			}
			else                      // West
			{
				Mower.x = (Mower.x + (8 - vInput.j));
				Mower.y = (Mower.y + vInput.i);
			}
		}

		Mower.x %= 8;      // keep the mower on the toriodal lawn...
		Mower.y %= 8;

		return vInput;
	}
}

Vector PROG2( Gene *pg )
{
	Translate( pg );
	return (Translate( pg->pgNext ));
}


// Terminal Set...

// Turn the mower left and return (0,0) Koza def'n..
Vector LEFT()
{
	if (Mower.Energy) // do you have any energy left to do something
	{
		Mower.Energy--;
		Mower.Moving = (Mower.Moving + 1) % 4;
	}
	return ZeroVector();
}

// Move the mower forward and return (0,0) Koza def'n..
Vector MOW()
{
	if (Mower.Energy)   // do you have any energy left to move with
	{
		Mower.Energy--;

		if ( Mower.Moving % 2 ) // if it is odd value 1,3 it is north,south
		{
			if ( Mower.Moving == 1 )  Mower.x = ( Mower.x + 7 ) % 8;
			else                                                                                    Mower.x = ( Mower.x + 1 ) % 8;
		}
		else
		{
			if ( Mower.Moving == 0 )        Mower.y = ( Mower.y + 1 ) % 8;
			else                                                                                    Mower.y = ( Mower.y + 7 ) % 8;
		}

// mow the grass in the area in which you have moved....
		Lawn[Mower.x][Mower.y] = 0;
	}

// this ensures closure of the system.....
	return ZeroVector();
}


Vector ZeroVector()
{
// this ensures closure of the system.....
	Vector vOutput;
	vOutput.i = 0; vOutput.j = 0;
	return vOutput;
}

// mower.cpp

