/* lawn.cpp */

//--------------------------------------------------------------------------
// This code is a component of Genetic Programming in C++ (Version 0.40)
// Copyright Adam P. Fraser, 1993,1994
// This code is released for non-commercial use only.
// For comments, improvements, additions (or even money !?) contact:
// Adam Fraser, Postgraduate Section, Dept of Elec & Elec Eng,
// Maxwell Building, University Of Salford, Salford, M5 4WT, United Kingdom.
// Internet: a.fraser@eee.salford.ac.uk
// Tel: (UK) 061 745 5000 x3633
// Fax: (UK) 061 745 5999
//--------------------------------------------------------------------------


#include "lawn.hpp"

//  Function Prototypes..............................................
void CreateLawn( void );
unsigned char CheckLawn( void );

// GLOBAL variables..................................................
unsigned char Lawn[LawnHorizontal][LawnVertical];


// Making the array sub routine......................................

void CreateLawn( void )
{
	for ( int i = 0; i < LawnHorizontal; i++ ) 
		for ( int j = 0; j < LawnVertical; j++ )
			Lawn[i][j] = 1;
}

// returns the amount of grass left ( note left not mowed )
unsigned char CheckLawn( void )
{
  unsigned char count = 0;
	for ( int i = 0; i < LawnHorizontal; i++ )
		for ( int j = 0; j < LawnVertical; j++ )
			count += Lawn[i][j];
	return count;
}


/* lawn.cpp */
