function y = ungroup(x,n)
% UNGROUP Access values stored in group.
%
% UNGROUP(X,N)
%   X - Group of matrices (created with GROUP).
%   N - Index of matrix to access.
% Returns Nth matrix in X.
%
% UNGROUP(X)
% Returns number of matrices in X.
%
% EXAMPLE: p = group(rand(2,3),1:4,'hello');
%          m = ungroup(p,1)
%          v = ungroup(p,2)
%          s = ungroup(p,3)
%
% SEE ALSO: group, isgroup

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

if ~isgroup(x)
  error('Attempt to ungroup already ungrouped value.')
end

if nargin == 1
  y = x(2);
elseif n >= 1 & n <= x(2)
  s = x([1:5]+(n-1)*5+2);
  y = reshape(x(s(1):(s(1)+s(2)-1)),s(3),s(4));
  if s(5), y = setstr(y); end
else
  s = [];
end
 
