% Stage 4b for Truck Demonstration

% Copyright (c) 1993 by PWS Publishing Company

set(info_win,'vis','off');
set(info_str,'string','');

% SIMULATION OF CONTROLLED TRUCK
% ==============================

% SETUP DISPLAY WINDOWS
scrn = [640,480,640,480];

set(f1,'name','Controlled Truck: Controller 2','pos',[20,20,600,430]./scrn);
set([f2,f3,f4,f5],'vis','off');

% INITIAL STATE
s0 = [45; -60; 360*deg];

% Horizontal position = 50 meters
% Vertical position = -60 meters
% Truck angle = 360 degrees

% TIME
t0 = 0;
t1 = 200;
dt= 0.3;
T = (t0+dt):dt:t1;
steps = length(T);

S = zeros(3,steps);
U = zeros(1,steps);

s = s0;
trkplot(s,0,f1,2)
drawnow;

for i=1:steps

  % RE-EVALUATE CONTROLLER EVERY 5 TIME STEPS
  if rem(i,5) == 1
    u = frule(A,C,Z,[s(1); s(3)]);
  end

  % UPDATE STATE
  s = s + dt * trukmod(s,u);

  % PLOT EVERY 5 TIME STEPS
  if rem(i,5) == 1
    trkplot(s,u,f1,0)
  end

  % SAVE VALUES
  S(:,i) = s;
  U(i) = u;

  % FINISH IF HORIZONTAL POSITION >= 0
  if all(s(2) >= 0)
    steps = i;
    S = S(:,1:steps);
    U = U(1:steps);
    T = T(1:steps);
    t1 = t0+steps*dt;
    break
  end
end

set(info_str(1),'string','View Responses...?');
set(b(2),'vis','off');
set(b(3),'string','Responses','callback','trkdemof');
set(info_win,'vis','on');



