function g=somewhat(g)
% SOMEWHAT Applies linguistic hedge "SOMEWHAT".
%
% SOMEWHAT(G)
%   G - Row vector(s) of grades.
% Returns new row vector(s) of grades after applying
%   a hedge of 0.5.
%
% EXAMPLE: s = 0:.1:10;
%          g1 = large(s);
%          g2 = somewhat(g1);
%          plotfs(s,'Fuzzy Sets: Large & Somewhat Large')
%          plot(s,g1,'--',s,g2)
%          hold off
%
% SEE ALSO: exactly, extremly, hedge, slightly, vaguely, very

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

g = hedge(g,0.5);
