% Stage 2 for Pendulum Demonstration

% Copyright (c) 1993 by PWS Publishing Company

% SIMULATION OF UNCONTROLLED PENDULUM
% ===================================

set(info_win,'vis','off');
set(info_str,'string','');
delete(han);

% INITIAL STATE
deg = pi/180;
x0 = [0; 0; 1*deg; 0*deg];

% Cart position = 0 meters
% Cart velocity = 0 meters/sec
% Pendulum angle = 1 degree
% Pendulum velocity = 0 degrees

% TIME
t0 = 0;
t1 = 5;
dt= 0.05;
T = (t0+dt):dt:t1;
steps = length(T);

% FORCE
u = 0;

X = zeros(4,steps);

x = x0;
penplot(x,u,0,f1,1);
drawnow;

for i=1:steps

  % UPDATE STATE
  x = x + dt * pendmod(x,u);
  
  % CHECK FOR COLLISION OF PENDULUM WITH BASE
  if abs(x(3)) > pi/2, x(3) = sign(x(3))*pi/2; end

  % PLOT EVERY 8 TIMESTEPS
	 if rem(i,4) <= eps
     penplot(x,u,i*dt,f1,0);
	 end

  % SAVE VALUES
	 X(:,i) = x;
end

left=(scrnsz(3)-300)/2;
botm=(scrnsz(4)-80)/2;
set(info_win,'pos',[left,botm,300,80]);
set(info_str(1),'string','View Responses...?','pos',[20,55,260,20]);
set(info_str(2),'pos',[20,30,260,20]);
set(b(1),'pos',[7,5,90,20],'vis','on');
set(b(2),'vis','off','pos',[105,5,90,20]);
set(b(3),'string','Responses','callback','pendemoc','pos',[203,5,90,20],...
         'vis','on');
set(info_win,'vis','on');

