% Stage 4 for Number Recognition Demonstration

% Copyright (c) 1993 by PWS Publishing Company

% NORMALIZE DRAWING
% =================

pts=get(f1,'userdata');
set(f1,'pointer','arrow','windowbuttondownfcn','');
if ~length(pts),
 left=(scrnsz(3)-300)/2;
 botm=(scrnsz(4)-80)/2;
 set(info_win,'pos',[left,botm,300,80]);
 set(b([1,3]),'vis','off');
 set(b(2),'string','OK','callback',...
         'set(f1,''pointer'',''crosshair'');clc;numdemoc','vis','on',...
         'pos',[105,5,90,20]);
 set(info_str(1),'string','You have to draw a number.','pos',[20,55,260,20]);
 set(info_str(2),'pos',[20,30,260,20]);
 set(info_win,'vis','on');
else

 X = pts(1,:);
 Y = pts(2,:);
 maxx = max(X);
 minx = min(X);
 ranx = maxx-minx;
 maxy = max(Y);
 miny = min(Y);
 rany = maxy-miny;

% HANDLE 1's

 if ranx == 0
   ranx = len1
 elseif (rany/ranx) > 8
   ranx = len1;
 end
 
 mult = (len1-1)/ranx;
 X = (X-minx)*mult+1;
 mult = (len2-1)/rany;
 Y = (Y-miny).*((len2-1)/rany)+1;
 
% FILL IN POINTS
% ==============

 bv = zeros(len1,len2);
 bv(round(X(1)),round(Y(1))) = 1;
 m1 = diff(X);
 m2 = diff(Y);
 for i=1:(length(X)-1)
   for j=0.01:0.01:1
     bv(round(X(i)+j*m1(i)),round(Y(i)+j*m2(i))) = 1;
   end
 end
 z = table(1:len1,1:len2)';
 delCol = find(bv == 0);
 z(:,delCol) = [];

% DRAW SUPPORT POINTS
% ===================
 
 ln=get(ax,'userdata');
 set(ln,'vis','off');
 figure(f1);
 title ('RESIZED CHARACTER');
 line('xdata',z(1,:),'ydata',z(2,:),'linestyle','*','color','g','erase','xor')
 hold off

% CONVERT POINTS INTO SUPPORT COORDINATES
% =======================================

 x = s1(z(1,:));
 y = s2(z(2,:));

 left=(scrnsz(3)-300)/2;
 botm=(scrnsz(4)-80)/2;
 set(info_win,'pos',[left,botm,300,80]);
 set(info_str(1),'string','Filling empty spaces.','pos',[20,55,260,20]);
 set(info_str(2),'string','Invoke Recognition...?','pos',[20,30,260,20]);
 set(b([1,3]),'vis','on');
 set(b(1),'pos',[7,5,90,20]);
 set(b(2),'vis','off','pos',[105,5,90,20]);
 set(b(3),'string','Recognize','callback','numdemoe',...
                 'pos',[203,5,90,20]);
 set(info_win,'vis','on');
end 


