function g=flatbump(s,v)
% FLATBUMP Creates flat bump shaped fuzzy sets.
%
% FLATBUMP(S,[A1,B1,C1,D1,E1,F1; ...; An,Bn,Cn,Dn,En,Fn])
%   S  - Support (row) vector.
%   Ai - Left side for ith bump.
%   Bi - Left midway-point for ith bump.
%   Ci - Left peak for ith grade vector.
%   Di - Right peak for ith bump.
%   Ei - Right midway-point for ith bump.
%   Fi - Right side for ith bump.
% Returns matrix of n flat bump shaped grade vectors
%   defined over support vector S.
%
% EXAMPLE: s = 0:.1:10;
%          g = flatbump(s,[1 2 3 4 5 6]);
%          plotfs(s,'Flat Bump Shaped Fuzzy Set');
%          plot(s,g);
%          hold off
%
% SEE ALSO: Bell, Bump, Rectangl, Single, Trapzoid, Triangle

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

[vr,vc] = size(v);
g = zeros(vr,length(s));

for i=1:vr
  a = v(i,1);
  b = v(i,2);
  c = v(i,3);
  d = v(i,4);
  e = v(i,5);
  f = v(i,6);

  up1 = find((s > a) & (s < b));
  up2 = find((s >= b) & (s < c));
  peak = find(s >= c & s <= d);
  down1 = find((s > d) & (s <= e));
  down2 = find((s > e) & (s < f));

  if length(up1), g(i,up1) = (1-cos((s(up1)-a)/(b-a)*pi*0.5))*0.5; end
  if length(up2), g(i,up2) = (sin((s(up2)-b)/(c-b)*pi*0.5) * 0.5 + 0.5); end
  if length(peak), g(i,peak) = ones(1,length(peak)); end
  if length(down1), g(i,down1) = cos((s(down1)-d)/(e-d)*pi*0.5)*0.5+0.5; end
  if length(down2), g(i,down2) = (1-sin((s(down2)-e)/(f-e)*pi*0.5))*0.5; end
end
