function y=centroid(s,g)
% CENTROID Centroid defuzzification.
%
% CENTROID(S,G)
%   S - Row vector of support values.
%   G - Row vector(s) of associated grade values.
% Returns centroid support value.
%
% EXAMPLE: s = 0:.1:10;
%          g = and([large(s); near(s,6)]);
%          c = centroid(s,g);
%          plotfs(s,'Centroid of Large and Near 6')
%          plot(s,g,[c c],[0 1])
%          hold off
%
% SEE ALSO: maxgrade, mingrade, alphacut, betacut

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

[gr,gc] = size(g);
ds = diff(s);
s1 = s(1:gc-1);
y = zeros(gr,1);
for i=1:gr
  g1 = g(i,1:gc-1);
  dg = diff(g(i,:));
  G = sum(ds .* (g1 + dg.*0.5));
  GS = sum(ds .* (ds .* (dg*(1/3) + g1*0.5) + s1 .* (dg*0.5 + g1)));
  y(i,:) = GS/G;
  z = abs(s-y(i,:));
  index = find(z == min(z));
end
