/*
 * Togai InfraLogic (R) Fuzzy-C Compiler Version 2.5.0
 *
 * Source file: "demo.til"
 *
 * Compiled Tue Oct 13 11:54:13 1992
 *
 * Selected options:
 * Default map size:            256
 * Default map type:            FUBYTE
 * Output C format:             OFF
 * Emit unused MEMBERs:         ON
 * Force expr:                  OFF
 * Force map:                   ON
 * Generate debug code:         OFF
 */

/*
 * Portability definitions and internal structures.
 */

#include <stdio.h>
#include <string.h>
#include <tilcomp.h>
#include <fcdslib.h>
#include "demo.h"

FUBYTE _Theta_NM_map[] = {
/*00000*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00010*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00020*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00030*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00040*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00050*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00060*/ 255, 255, 255, 255, 255, 247, 239, 231, 223, 215, 
/*00070*/ 207, 199, 191, 183, 175, 167, 159, 151, 143, 135, 
/*00080*/ 127, 119, 111, 103,  95,  87,  79,  71,  63,  55, 
/*00090*/  47,  39,  31,  23,  15,   7,   0,   0,   0,   0, 
/*00100*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00110*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00120*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00130*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00140*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00150*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00160*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00170*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00180*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00190*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00200*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00210*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00220*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00230*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00240*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00250*/   0,   0,   0,   0,   0,   0
};

FUBYTE _Theta_NS_map[] = {
/*00000*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00010*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00020*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00030*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00040*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00050*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00060*/   0,   0,   0,   0,   0,   7,  15,  23,  31,  39, 
/*00070*/  47,  55,  63,  71,  79,  87,  95, 103, 111, 119, 
/*00080*/ 127, 135, 143, 151, 159, 167, 175, 183, 191, 199, 
/*00090*/ 207, 215, 223, 231, 239, 247, 255, 247, 239, 231, 
/*00100*/ 223, 215, 207, 199, 191, 183, 175, 167, 159, 151, 
/*00110*/ 143, 135, 127, 119, 111, 103,  95,  87,  79,  71, 
/*00120*/  63,  55,  47,  39,  31,  23,  15,   7,   0,   0, 
/*00130*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00140*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00150*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00160*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00170*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00180*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00190*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00200*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00210*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00220*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00230*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00240*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00250*/   0,   0,   0,   0,   0,   0
};

FUBYTE _Theta_Z_map[] = {
/*00000*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00010*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00020*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00030*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00040*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00050*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00060*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00070*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00080*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00090*/   0,   0,   0,   0,   0,   0,   0,   7,  15,  23, 
/*00100*/  31,  39,  47,  55,  63,  71,  79,  87,  95, 103, 
/*00110*/ 111, 119, 127, 135, 143, 151, 159, 167, 175, 183, 
/*00120*/ 191, 199, 207, 215, 223, 231, 239, 247, 255, 247, 
/*00130*/ 239, 231, 223, 215, 207, 199, 191, 183, 175, 167, 
/*00140*/ 159, 151, 143, 135, 127, 119, 111, 103,  95,  87, 
/*00150*/  79,  71,  63,  55,  47,  39,  31,  23,  15,   7, 
/*00160*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00170*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00180*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00190*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00200*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00210*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00220*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00230*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00240*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00250*/   0,   0,   0,   0,   0,   0
};

FUBYTE _Theta_PS_map[] = {
/*00000*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00010*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00020*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00030*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00040*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00050*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00060*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00070*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00080*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00090*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00100*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00110*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00120*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   7, 
/*00130*/  15,  23,  31,  39,  47,  55,  63,  71,  79,  87, 
/*00140*/  95, 103, 111, 119, 127, 135, 143, 151, 159, 167, 
/*00150*/ 175, 183, 191, 199, 207, 215, 223, 231, 239, 247, 
/*00160*/ 255, 247, 239, 231, 223, 215, 207, 199, 191, 183, 
/*00170*/ 175, 167, 159, 151, 143, 135, 127, 119, 111, 103, 
/*00180*/  95,  87,  79,  71,  63,  55,  47,  39,  31,  23, 
/*00190*/  15,   7,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00200*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00210*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00220*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00230*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00240*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00250*/   0,   0,   0,   0,   0,   0
};

FUBYTE _Theta_PM_map[] = {
/*00000*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00010*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00020*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00030*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00040*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00050*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00060*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00070*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00080*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00090*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00100*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00110*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00120*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00130*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00140*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00150*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00160*/   0,   7,  15,  23,  31,  39,  47,  55,  63,  71, 
/*00170*/  79,  87,  95, 103, 111, 119, 127, 135, 143, 151, 
/*00180*/ 159, 167, 175, 183, 191, 199, 207, 215, 223, 231, 
/*00190*/ 239, 247, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00200*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00210*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00220*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00230*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00240*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00250*/ 255, 255, 255, 255, 255, 255
};

FUBYTE _dTheta_NM_map[] = {
/*00000*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00010*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00020*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00030*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00040*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00050*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00060*/ 255, 255, 255, 255, 255, 247, 239, 231, 223, 215, 
/*00070*/ 207, 199, 191, 183, 175, 167, 159, 151, 143, 135, 
/*00080*/ 127, 119, 111, 103,  95,  87,  79,  71,  63,  55, 
/*00090*/  47,  39,  31,  23,  15,   7,   0,   0,   0,   0, 
/*00100*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00110*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00120*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00130*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00140*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00150*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00160*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00170*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00180*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00190*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00200*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00210*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00220*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00230*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00240*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00250*/   0,   0,   0,   0,   0,   0
};

FUBYTE _dTheta_NS_map[] = {
/*00000*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00010*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00020*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00030*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00040*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00050*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00060*/   0,   0,   0,   0,   0,   7,  15,  23,  31,  39, 
/*00070*/  47,  55,  63,  71,  79,  87,  95, 103, 111, 119, 
/*00080*/ 127, 135, 143, 151, 159, 167, 175, 183, 191, 199, 
/*00090*/ 207, 215, 223, 231, 239, 247, 255, 247, 239, 231, 
/*00100*/ 223, 215, 207, 199, 191, 183, 175, 167, 159, 151, 
/*00110*/ 143, 135, 127, 119, 111, 103,  95,  87,  79,  71, 
/*00120*/  63,  55,  47,  39,  31,  23,  15,   7,   0,   0, 
/*00130*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00140*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00150*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00160*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00170*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00180*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00190*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00200*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00210*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00220*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00230*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00240*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00250*/   0,   0,   0,   0,   0,   0
};

FUBYTE _dTheta_Z_map[] = {
/*00000*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00010*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00020*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00030*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00040*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00050*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00060*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00070*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00080*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00090*/   0,   0,   0,   0,   0,   0,   0,   7,  15,  23, 
/*00100*/  31,  39,  47,  55,  63,  71,  79,  87,  95, 103, 
/*00110*/ 111, 119, 127, 135, 143, 151, 159, 167, 175, 183, 
/*00120*/ 191, 199, 207, 215, 223, 231, 239, 247, 255, 247, 
/*00130*/ 239, 231, 223, 215, 207, 199, 191, 183, 175, 167, 
/*00140*/ 159, 151, 143, 135, 127, 119, 111, 103,  95,  87, 
/*00150*/  79,  71,  63,  55,  47,  39,  31,  23,  15,   7, 
/*00160*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00170*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00180*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00190*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00200*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00210*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00220*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00230*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00240*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00250*/   0,   0,   0,   0,   0,   0
};

FUBYTE _dTheta_PS_map[] = {
/*00000*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00010*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00020*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00030*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00040*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00050*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00060*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00070*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00080*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00090*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00100*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00110*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00120*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   7, 
/*00130*/  15,  23,  31,  39,  47,  55,  63,  71,  79,  87, 
/*00140*/  95, 103, 111, 119, 127, 135, 143, 151, 159, 167, 
/*00150*/ 175, 183, 191, 199, 207, 215, 223, 231, 239, 247, 
/*00160*/ 255, 247, 239, 231, 223, 215, 207, 199, 191, 183, 
/*00170*/ 175, 167, 159, 151, 143, 135, 127, 119, 111, 103, 
/*00180*/  95,  87,  79,  71,  63,  55,  47,  39,  31,  23, 
/*00190*/  15,   7,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00200*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00210*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00220*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00230*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00240*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00250*/   0,   0,   0,   0,   0,   0
};

FUBYTE _dTheta_PM_map[] = {
/*00000*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00010*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00020*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00030*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00040*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00050*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00060*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00070*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00080*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00090*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00100*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00110*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00120*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00130*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00140*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00150*/   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
/*00160*/   0,   7,  15,  23,  31,  39,  47,  55,  63,  71, 
/*00170*/  79,  87,  95, 103, 111, 119, 127, 135, 143, 151, 
/*00180*/ 159, 167, 175, 183, 191, 199, 207, 215, 223, 231, 
/*00190*/ 239, 247, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00200*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00210*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00220*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00230*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00240*/ 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
/*00250*/ 255, 255, 255, 255, 255, 255
};

/*
 * User defined objects.
 */

/*
 * VAR Theta
 */

/*
 * VAR dTheta
 */

/*
 * VAR Current
 */

/*
 * MEMBER NM
 */

/*
 *    moment: -6997.33
 *      area: 80
 *  centroid: -87.4667
 *    height: 1
 * hcentroid: -87.4667
 */

struct FCCicb _Current_NM_cbinfo = { -6997L, 80L };

/*
 * MEMBER NS
 */

/*
 *    moment: -1024
 *      area: 32
 *  centroid: -32
 *    height: 1
 * hcentroid: -32
 */

struct FCCicb _Current_NS_cbinfo = { -1024L, 32L };

/*
 * MEMBER Z
 */

/*
 *    moment: 0
 *      area: 32
 *  centroid: 0
 *    height: 1
 * hcentroid: 0
 */

struct FCCicb _Current_Z_cbinfo = { 0L, 32L };

/*
 * MEMBER PS
 */

/*
 *    moment: 1024
 *      area: 32
 *  centroid: 32
 *    height: 1
 * hcentroid: 32
 */

struct FCCicb _Current_PS_cbinfo = { 1024L, 32L };

/*
 * MEMBER PM
 */

/*
 *    moment: 6869.83
 *      area: 79
 *  centroid: 86.9599
 *    height: 1
 * hcentroid: 86.9599
 */

struct FCCicb _Current_PM_cbinfo = { 6869L, 79L };

/*
 * SOURCE dummy
 */

void dummy (void);
void dummy ()
{
}

/* Include some information from the graphical shell so that we */
/* can set some flags and communicate what's going on with the  */
/* Fuzzy-C interface.                                           */

#include "pendemo.h"
extern struct rulelistelem rulelist[10];


/*
 * FUZZY Pendulum
 */

void Pendulum (SBYTE Theta, SBYTE dTheta, SBYTE *Current)
{
    FUBYTE _alpha;
    FUBYTE _Theta_is_NS;
    FUBYTE _Theta_is_Z;
    FUBYTE _Theta_is_PS;
    FUBYTE _dTheta_is_NS;
    FUBYTE _dTheta_is_Z;
    FUBYTE _dTheta_is_PS;
    struct FCCicb _Current_temp;

    memset (&_Current_temp, 0, sizeof (_Current_temp));

    _Theta_is_NS = _Theta_NS_map[ (int) ((((SLONG) Theta) - -128L))];
    _Theta_is_Z = _Theta_Z_map[ (int) ((((SLONG) Theta) - -128L))];
    _Theta_is_PS = _Theta_PS_map[ (int) ((((SLONG) Theta) - -128L))];
    _dTheta_is_NS = _dTheta_NS_map[ (int) ((((SLONG) dTheta) - -128L))];
    _dTheta_is_Z = _dTheta_Z_map[ (int) ((((SLONG) dTheta) - -128L))];
    _dTheta_is_PS = _dTheta_PS_map[ (int) ((((SLONG) dTheta) - -128L))];

/*
 * FRAGMENT Frag1a
 */

    if (!rulelist[PM_Z].disabled) {

/*
 * RULE Rule1
 */

    _alpha = min(_Theta_PM_map[ (int) ((((SLONG) Theta) - -128L))], _dTheta_is_Z);

    if (_alpha != ((FUBYTE) 0)) {

        /* Current = NM */

        _Current_temp.moment += _alpha * _Current_NM_cbinfo.moment;
        _Current_temp.area += _alpha * _Current_NM_cbinfo.area;

    }

/*
 * FRAGMENT Frag1b
 */

	rulelist[PM_Z].DOM = _alpha;
    }

/*
 * FRAGMENT Frag2a
 */

    if (!rulelist[Z_NM].disabled) {

/*
 * RULE Rule2
 */

    _alpha = min(_Theta_is_Z, _dTheta_NM_map[ (int) ((((SLONG) dTheta) - -128L))]);

    if (_alpha != ((FUBYTE) 0)) {

        /* Current = PM */

        _Current_temp.moment += _alpha * _Current_PM_cbinfo.moment;
        _Current_temp.area += _alpha * _Current_PM_cbinfo.area;

    }

/*
 * FRAGMENT Frag2b
 */

	rulelist[Z_NM].DOM = _alpha;
    }

/*
 * FRAGMENT Frag3a
 */

    if (!rulelist[Z_PM].disabled) {

/*
 * RULE Rule3
 */

    _alpha = min(_Theta_is_Z, _dTheta_PM_map[ (int) ((((SLONG) dTheta) - -128L))]);

    if (_alpha != ((FUBYTE) 0)) {

        /* Current = NM */

        _Current_temp.moment += _alpha * _Current_NM_cbinfo.moment;
        _Current_temp.area += _alpha * _Current_NM_cbinfo.area;

    }

/*
 * FRAGMENT Frag3b
 */

	rulelist[Z_PM].DOM = _alpha;
	}

/*
 * FRAGMENT Frag4a
 */

    if (!rulelist[NM_Z].disabled) {

/*
 * RULE Rule4
 */

    _alpha = min(_Theta_NM_map[ (int) ((((SLONG) Theta) - -128L))], _dTheta_is_Z);

    if (_alpha != ((FUBYTE) 0)) {

        /* Current = PM */

        _Current_temp.moment += _alpha * _Current_PM_cbinfo.moment;
        _Current_temp.area += _alpha * _Current_PM_cbinfo.area;

    }

/*
 * FRAGMENT Frag4b
 */

	rulelist[NM_Z].DOM = _alpha;
    }

/*
 * FRAGMENT Frag5a
 */

    if (!rulelist[PS_Z].disabled) {

/*
 * RULE Rule5
 */

    _alpha = min(_Theta_is_PS, _dTheta_is_Z);

    if (_alpha != ((FUBYTE) 0)) {

        /* Current = NS */

        _Current_temp.moment += _alpha * _Current_NS_cbinfo.moment;
        _Current_temp.area += _alpha * _Current_NS_cbinfo.area;

    }

/*
 * FRAGMENT Frag5b
 */

	rulelist[PS_Z].DOM = _alpha;
    }

/*
 * FRAGMENT Frag6a
 */

    if (!rulelist[Z_NS].disabled) {

/*
 * RULE Rule6
 */

    _alpha = min(_Theta_is_Z, _dTheta_is_NS);

    if (_alpha != ((FUBYTE) 0)) {

        /* Current = PS */

        _Current_temp.moment += _alpha * _Current_PS_cbinfo.moment;
        _Current_temp.area += _alpha * _Current_PS_cbinfo.area;

    }

/*
 * FRAGMENT Frag6b
 */

	rulelist[Z_NS].DOM = _alpha;
    }

/*
 * FRAGMENT Frag7a
 */

    if (!rulelist[NS_PS].disabled) {

/*
 * RULE Rule7
 */

    _alpha = min(_Theta_is_NS, _dTheta_is_PS);

    if (_alpha != ((FUBYTE) 0)) {

        /* Current = Z */

        _Current_temp.moment += _alpha * _Current_Z_cbinfo.moment;
        _Current_temp.area += _alpha * _Current_Z_cbinfo.area;

    }

/*
 * FRAGMENT Frag7b
 */

	rulelist[NS_PS].DOM = _alpha;
    }

/*
 * FRAGMENT Frag8a
 */

    if (!rulelist[Z_PS].disabled) {

/*
 * RULE Rule8
 */

    _alpha = min(_Theta_is_Z, _dTheta_is_PS);

    if (_alpha != ((FUBYTE) 0)) {

        /* Current = NS */

        _Current_temp.moment += _alpha * _Current_NS_cbinfo.moment;
        _Current_temp.area += _alpha * _Current_NS_cbinfo.area;

    }

/*
 * FRAGMENT Frag8b
 */

	rulelist[Z_PS].DOM = _alpha;
    }

/*
 * FRAGMENT Frag9a
 */

    if (!rulelist[NS_Z].disabled) {

/*
 * RULE Rule9
 */

    _alpha = min(_Theta_is_NS, _dTheta_is_Z);

    if (_alpha != ((FUBYTE) 0)) {

        /* Current = PS */

        _Current_temp.moment += _alpha * _Current_PS_cbinfo.moment;
        _Current_temp.area += _alpha * _Current_PS_cbinfo.area;

    }

/*
 * FRAGMENT Frag9b
 */

	rulelist[NS_Z].DOM = _alpha;
    }

/*
 * FRAGMENT Frag10a
 */

    if (!rulelist[PS_NS].disabled) {

/*
 * RULE Rule10
 */

    _alpha = min(_Theta_is_PS, _dTheta_is_NS);

    if (_alpha != ((FUBYTE) 0)) {

        /* Current = Z */

        _Current_temp.moment += _alpha * _Current_Z_cbinfo.moment;
        _Current_temp.area += _alpha * _Current_Z_cbinfo.area;

    }

/*
 * FRAGMENT Frag10b
 */

	rulelist[PS_NS].DOM = _alpha;
    }

/*
 * FRAGMENT Frag11a
 */

    if (!rulelist[Z_Z].disabled) {

/*
 * RULE Rule11
 */

    _alpha = min(_Theta_is_Z, _dTheta_is_Z);

    if (_alpha != ((FUBYTE) 0)) {

        /* Current = Z */

        _Current_temp.moment += _alpha * _Current_Z_cbinfo.moment;
        _Current_temp.area += _alpha * _Current_Z_cbinfo.area;

    }

/*
 * FRAGMENT Frag11b
 */

	rulelist[Z_Z].DOM =_alpha;
    }

    if (_Current_temp.area != 0L)
        *Current = ((SBYTE) (_Current_temp.moment / _Current_temp.area));
    else
        *Current = ((SBYTE) 0);

}

/*
 * PROJECT Pend
 */

void Pend (SBYTE Theta, SBYTE dTheta, SBYTE *Current)
{
/*
 * SOURCE dummy
 */

    dummy ();

/*
 * FUZZY Pendulum
 */

    Pendulum (Theta, dTheta, Current);

}

