#! /bin/sh
## set -x
#############################################################################
#
# create_deftemplate.sh
#
# Bourne shell script which creates a text file of CLIPS deftemplates.
# CLIPS facts that are defined map exactly to Sybase tables named in
# this script.
#
# Instructions to the CLIPS programmer:
# Lines beginning with "# ==>" are instructions.  Follow them.
# Change the lines following "# ==>" as instructed.
# Invoke script from the UNIX command line:  create_deftemplate.sh
# A file named "outfile" is created, containing your deftemplates.
# Include "outfile" into your CLIPS program.
#
# Note: "outfile" will contain a deftemplate for only one database table.
#       To create deftemplates for 4 tables (for example), do the following:
#       1.  Add the following lines to this script:
#           table2="mysecondtable"
#           table3="mythirdtable"
#           table4="myfourthtable"
#           where the value of each variable is set to a table name
#       2.  Change the value of numtables to 4:
#           numtables=4
#
#############################################################################
# ==> Make your changes below this line
# ==> Note: do not remove any double quotes in this file
# ==> change "mylogin" to be the name of your SQL server login account
dbuser="mylogin"
# ==> change "mypassword" to be your SQL server account password
dbpasswd="mypassword"
# ==> change "pubs" to be the name of the Sybase database you wish to use
dbname="pubs"
# ==> change "titleauthor" to be the name of a Sybase table in your database
table1="titleauthor"
# ==> change the value of "numtables" to be the number of tableX variables
numtables=1
# ==> Make your changes above this line

# name of output file:
outfile="outfile"

counter=1

while [ ${counter} -le ${numtables} ]
do
  eval T=\${table${counter}}
  echo "(deftemplate $T" >> ${outfile}
  isql -U${dbuser} -P${dbpasswd} << BAGEL | grep "[()]" >> ${outfile}
use ${dbname}
set nocount on
go
select c.name, c.type into #temp
from syscolumns c, sysobjects o
where c.id = o.id and o.name = "$T"
set rowcount 1
go
declare @cname varchar(45), @sybtype int
select @cname = name, @sybtype = type from #temp
while @@rowcount > 0
begin
  select "  (field ", @cname from #temp
  if @sybtype in (35, 39, 47, 58, 61, 111)
    select "    (type STRING) )"
  else if @sybtype in (59, 60, 62, 109, 110, 122)
    select "    (type NUMBER) )"
  else
    select "    (type INTEGER) )"
  delete #temp
  select @cname = name, @sybtype = type from #temp
end
go
BAGEL
  echo ")" >> ${outfile}
  counter=`expr ${counter} + 1`
done
