/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: sim.h,v 2.1 91/06/18 22:02:24 dick Exp $
*/

struct position {
	/* position of first and last token of a chunk */
	struct position *ps_next;
	int ps_type;		/*	first = 0, last = 1 */
	unsigned int ps_tk_cnt;	/*	in tokens; set by add_run() in pass 1 */
	long ps_fs_pos;		/*	same, in fseek positions; set by
					pass2(), used by chunk_open() in pass 3
					to position the file
				*/
	unsigned int ps_nl_cnt;	/*	same, in line numbers; set by pass2(),
					used by pass3() to report line numbers
				*/
};

/*	Although all other segments of data in this program are described by
	giving the position of the first in the segment and that of the
	first not in the segment (so the size is the difference of the two),
	a `chunk' is given by first and last. This is done because later on we
	are interested in the actual position of the last token of it, and
	the position of the first token not in the segment gives no
	indication about that.
*/

struct chunk {
	/* a chunk of text in various representations */
	struct text *ch_text;	/*	a pointer to the file text; set by
					add_run() in pass 1, used mainly to
					retrieve the file's name
				*/
	struct position ch_first;/*	first in chunk */
	struct position ch_last;/*	last in chunk */
};

struct run {			/*	a 'run' of coincident tokens */
	struct chunk rn_cn0;	/*	chunk in left file */
	struct chunk rn_cn1;	/*	chunk in right file */
	unsigned int rn_quality;
};

struct text {
	char *tx_fname;		/*	the file name */
	struct position *tx_pos;/*	list of positions in this file that
					are part of a chunk; will be sorted
					and updated by pass 2
				*/
	unsigned int tx_start;	/*	positions in tk_buff for the text */
	unsigned int tx_limit;
	unsigned int tx_nl_start;/*	possibly newline pointer for pass2 */
	unsigned int tx_nl_limit;
};

