/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: idf.c,v 2.2 92/06/30 15:23:01 dick Exp $
*/

/*	Idf module:
	TOKEN idf_in_list(str, list, dflt)
			char *str; struct idf l[]; TOKEN dflt;
		looks up a keyword in a list of keywords, represented as an
		array of struct idf, and return its translation as a token;
		dflt is returned if the keyword is not found.
	TOKEN idf_hashed(str) char *str;
		returns a token unequal to SKIP or EOL, derived from the str
		through hashing
	It is assumed that SKIP will be ignored by the user of this module.
*/

#include	"idf.h"
#include	"token.h"

TOKEN
findidf(str, list, size, dflt)
	char *str;
	struct idf list[];
	unsigned int size;
	TOKEN dflt;
{
	register int first = 0;
	register int last = size - 1;

	while (first < last) {
		register int middle = (first + last) / 2;

		if (strcmp(str, list[middle].id_tag) > 0) {
			first = middle + 1;
		}
		else {
			last = middle;
		}
	}
	return (
		strcmp(str, list[first].id_tag) == 0 ? list[first].id_tr : dflt
	);
}

TOKEN
idf_hashed(str)
	char *str;
{
	register int h = 0;
	
	while (*str) {
		h = ((h << 1) + *str++) % 253;	/* 0 <= h < 253 */
	}
	return NORM(h + 1);			/* 1 <= h < 254 */
	/* this avoids SKIP (0) and EOL (255) */
}


