/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
	$Header: debug.c,v 2.2 92/06/30 16:16:25 dick Exp $
*/

#include	"debug.h"
#include	"private.h"
#include	"sim.h"
#include	"buff.h"
#include	"stream.h"

#ifdef	DB_HASH

db_forw_ref()
{
	extern unsigned int *forw_ref;
	int n;
	int fwr_cnt = 0;

	for (n = 0; n < text_length(); n++) {
		if (forw_ref[n]) {
			fwr_cnt++;
		}
	}
	printf("text_length = %u, fwr_cnt = %d\n", text_length(), fwr_cnt);
}

#endif	/* DB_HASH */

#ifdef	DB_TEXT

db_pr_text(txt)
	struct text *txt;
{	/* prints a text (in compressed form) */
	register int i;
	
	for (i = txt->tx_start; i < txt->tx_limit; i++) {
		show_token(tk_buff[i]);
	}
	printf("\n");
}

#endif	/* DB_TEXT */

#ifdef	DB_POS

db_pr_pos(pos)
	struct position *pos;
{
	printf("pos type: %s; token: %u, fseek: %ld, line#: %u\n",
		(pos->ps_type == 0 ? "first" : " last"),
		pos->ps_tk_cnt, pos->ps_fs_pos, pos->ps_nl_cnt
	);
}

db_pr_pos_list(pos)
	struct position *pos;
{
	while (pos) {
		db_pr_pos(pos);
		pos = pos->ps_next;
	}
}

db_pr_lex(fn)
	char *fn;
{
	printf("%s: lex_tk_cnt = %u, lex_fs_pos = %ld, lex_nl_cnt = %u\n",
			fn, lex_tk_cnt, lex_fs_pos, lex_nl_cnt);
}

#endif	/* DB_POS */

#ifdef	DB_RUN

PRIVATE db_chunk();

db_run(run)
	struct run *run;
{	/* prints detailed data about a run */
	register struct chunk *cnk0 = &run->rn_cn0;
	register struct chunk *cnk1 = &run->rn_cn1;
	
	printf("File %s / file %s:\n",
		cnk0->ch_text->tx_fname,
		cnk1->ch_text->tx_fname
	);
	printf("from token %u/%u to %u/%u:",
		cnk0->ch_first.ps_tk_cnt, cnk1->ch_first.ps_tk_cnt,
		cnk0->ch_last.ps_tk_cnt, cnk1->ch_last.ps_tk_cnt
	);
	printf(" from fseek pos. %ld/%ld to %ld/%ld:",
		cnk0->ch_first.ps_fs_pos, cnk1->ch_first.ps_fs_pos,
		cnk0->ch_last.ps_fs_pos, cnk1->ch_last.ps_fs_pos
	);
	printf(" from lines %u/%u to %u/%u:",
		cnk0->ch_first.ps_nl_cnt, cnk1->ch_first.ps_nl_cnt,
		cnk0->ch_last.ps_nl_cnt, cnk1->ch_last.ps_nl_cnt
	);
	printf(" %u %s\n",
		run->rn_quality,
		(run->rn_quality == 1 ? "token" : "tokens")
	);
	
	db_chunk(cnk0);
	db_chunk(cnk1);
}

PRIVATE
db_chunk(cnk)
	struct chunk *cnk;
{
	/*	print the tokens in the chunk, with a one-char margin
	*/
	register unsigned int i;
	struct position *first = &cnk->ch_first;
	register struct position *last = &cnk->ch_last;
	register unsigned int start = cnk->ch_text->tx_start;

	if (first->ps_tk_cnt > 0) {
		printf("...");
		show_token(tk_buff[start + first->ps_tk_cnt - 1]);
		printf("  ");
	}
	else {	/* create same offset as above */
		printf("       ");
	}
	
	for (i = first->ps_tk_cnt; i <= last->ps_tk_cnt; i++) {
		show_token(tk_buff[start + i]);
	}

	if (start + last->ps_tk_cnt + 1 < cnk->ch_text->tx_limit) {
		printf("  ");
		show_token(tk_buff[start + last->ps_tk_cnt + 1]);
		printf("...");
	}

	printf("\n");
}

#endif	/* DB_RUN */

