
#include "global.h"

#define TIME_LIMIT  1200    /* 20 minutes */
#define N_TESTS       10    /* number of tests at each value of p, q */


main( argc, argv )
    int     argc;
    char    *argv[];
{
    int         n, k, p_orig, q_orig, tests, found, consistent;
    NETWORK     C;
    SOLUTION    solution;
    double      p, q;


    srandom( 0 );

    n = 50;
    k =  5;

    for( p_orig = 10; p_orig <= 100; p_orig += 2 )
    for( q_orig = 10; q_orig <= 100; q_orig += 2 ) {

        for( tests = 1; tests <= N_TESTS; tests++ ) {

            generate_R( C, n, k, p_orig, q_orig );
            analyze( C, n, k, &p, &q );

            start_timers();
            set_limit( REAL, TIME_LIMIT );

            consistent = pre_arc( C, n, k );

            if( !consistent ) {
                printf( "0\t0\t%0.0f\t%0.0f\t%0.2f\n",
                    p, q, elapsed_time( VIRTUAL ) );
            }
            else {
                order_variables( variable_satisfy, sort, C, n, k );
                order_domains( domain_satisfy, C, n, k );

                solve( GBJ, C, n, k, solution, 1, &found );
                printf( "%d\t%d\t%0.0f\t%0.0f\t%0.2f\n",
                    checks, count, p, q, elapsed_time( VIRTUAL ) );
            }

            fflush( stdout );
        }
    }

    exit( 0 );
}

