
#include "global.h"


/*
 *  Generate a random (n x n) adjacency matrix representation, C, of
 *  a constraint satisfaction problem.  Each entry of C is a (k x k)
 *  binary matrix.  The CSP has n variables with domains of size k.
 *  An edge is labeled with a non-trivial constraint with independent
 *  probability p/100 and is labeled with U with probability (1-p/100).
 *  A non-trivial constraint is a random (0,1)-matrix where each entry
 *  is a 1 with independent probability q/100, and a 0 with probability
 *  (1-q/100).
 */
void
generate_R( C, n, k, p, q )
	NETWORK	C;
	int	n, k, p, q;
{
	int	i, j, a, b;
	long	random();


	/*
	 *  Initialize the (0,1)-matrices.
	 */
	for( i = 1; i <= n; i++ )
	for( j = 1; j <= n; j++ )
		if( i == j ) {
			/*
			 *  Diagonal: Initialize to I.
			 */
			for( a = 0; a < k; a++ )
			for( b = 0; b < k; b++ )
				if( a == b )
					C [i][i][a][b] = 1;
				else
					C [i][i][a][b] = 0;
		}
		else {
			/*
			 *  Off Diagonal: Initialize to U.
			 */
			for( a = 0; a < k; a++ )
			for( b = 0; b < k; b++ )
				C [i][j][a][b] = 1;
		}

	/*
	 *  Fill-in the (0,1)-matrices.
	 */
	for( i = 1;   i <= n; i++ )
	for( j = i+1; j <= n; j++ ) {
		if( ( random() % 100 ) >= p )	/* (100-p)% are labeled U */
			;/* leave it as a U */
		else {
			for( a = 0; a < k; a++ )
			for( b = 0; b < k; b++ ) {
				if( ( random() % 100 ) < q )	/*  q% ones  */
					;/* leave it as a one */
				else {
					C [i][j][a][b] = 0;
					C [j][i][b][a] = 0;
				}
			}
		}
	}
}

