
#include "global.h"


/*
 *  Generate the CSP for a random graph coloring problem.
 */
void
generate_C( C, n, k, p )
	NETWORK	C;
	int	n, k, p;
{
	int	i, j, a, b;
	long	random();


	/*
	 *  Initialize the (0,1)-matrices.
	 */
	for( i = 1; i <= n; i++ )
	for( j = 1; j <= n; j++ )
		if( i == j ) {
			/*
			 *  Diagonal, so initialize to I.
			 */
			for( a = 0; a < k; a++ )
			for( b = 0; b < k; b++ )
				if( a == b )
					C [i][i][a][b] = 1;
				else
					C [i][i][a][b] = 0;
		}
		else {
			/*
			 *  Off Diagonal, so initialize to U.
			 */
			for( a = 0; a < k; a++ )
			for( b = 0; b < k; b++ )
				C [i][j][a][b] = 1;
		}

	/*
	 *  Fill-in the (0,1)-matrices.
	 */
	for( i = 1;   i <= n; i++ )
	for( j = i+1; j <= n; j++ ) {
		if( ( random() % 100 ) >= p )	/* (100-p)% are labeled U */
			;/* leave it as a U */
		else {
			/* not-equal constraint */
			for( a = 0; a < k; a++ ) {
				C [i][j][a][a] = 0;
				C [j][i][a][a] = 0;
			}
		}
	}
}

