#include "global.h"


/*
 * Generate problems for graph coloring.  Each entry along the diagonal is set
 * to I, and the rest of the edges are appropriately assigned either U edges
 * (i.e. no constraint) or "not-equal" edges, depending on the given
 * probability.
 */
void generate(C, n, p)
NETWORK C;
int n, p;
{
    int i, j;

    for (i = 1; i <= n; i++) {
        C[i][i] = I;
        for (j = 1; j < i; j++) {
            C[i][j] = (random() % 100) < p ? NE : U;
            C[j][i] = C[i][j];
        }
    }
}
