#include "global.h"


/*
 * Check if the current instantiation of the variables is consistent by
 * looking at the edge between the current variable and all previous variables.
 */
static int consistent(C, solution, current)
NETWORK C;
int current;
SOLUTION solution;
{
    int i;

    for (i = 1; i < current; i++) {
        checks++;
        if (C[current][i][solution[current]][solution[i]] == 0)
            return(0);
    }
    return(1);
}


/*
 * Solve the constraint network using the simple BACKTRACKING (BT) method.  If
 * this is the first variable then initialize the data structures.  If a
 * solution is found then update the "found" variable, call the function to
 * process the solution, and return the value according to whether the first
 * solution is desired or all solutions.  Then, check if the timer has expired,
 * and if it has, return immediately.  Otherwise, begin checking each possible
 * instantiation of the variable.  For each domain value, perform the following
 * steps.  First, if preprocessing eliminated the value, disregard the rest of
 * the loop.  Otherwise, instantiate the variable, check if the network is
 * still consistent, and then call the backtracking routine recursively.  After
 * checking all possible domain values, return.
 */
int BT(C, n, k, solution, current, number, found)
NETWORK C;
int n, k, current, number, *found;
SOLUTION solution;
{
    int i;

    if (current == 1)
        *found = 0;
    if (current > n) {
        process_solution(C, n, solution);
        *found = 1;
        count++;
        return(number == 1 ? 1 : 0);
    }
    if (time_expired())
        return(1);
    for (i = 0; i < k; i++) {
        if (C[current][current][i][i] == 0)
            continue;
        solution[current] = i;
        if (consistent(C, solution, current))
            if (BT(C, n, k, solution, current + 1, number, found))
                return(1);
    }
    return(0);
}
