// Parameter caches.  These are global so that the can be accessed easily by
// methods in all the various classes.  In the event of multiple datmo
// instances in the same process, these would need to be the same for all.

#ifndef PARAMS_H
#define PARAMS_H

#include <ConfigSource/ConfigSource.h>
using namespace utils;

#ifndef EXTERN
#define EXTERN extern
#endif

EXTERN int _max_scan_size;
EXTERN double _pos_noise;
EXTERN double _disoriented_pos_noise;
EXTERN double _vague_pos_noise;
EXTERN double _min_noise_factor;
EXTERN double _occluded_noise_factor;
EXTERN double _angular_pos_noise;
EXTERN double _velocity_angular_pos_noise;
EXTERN double _initial_velocity_noise;
EXTERN double _initial_acceleration_noise;
EXTERN double _initial_angular_velocity_noise;
EXTERN double _process_position_noise;
EXTERN double _process_velocity_noise;
EXTERN double _process_acceleration_noise;
EXTERN double _process_angular_position_noise;
EXTERN double _process_angular_velocity_noise;
EXTERN double _line_tolerance;
EXTERN double _disoriented_line_tolerance;
EXTERN double _line_discard_fraction;
EXTERN double _corner_weight;
EXTERN double _cos_fit_big_difference;
EXTERN double _fit_much_better;
EXTERN double _compact_size;
EXTERN double _compact_min_density;
EXTERN double _linear_size;
EXTERN double _cos_min_corner_angle;
EXTERN unsigned int _min_line_points;
EXTERN unsigned int _min_segment_points;
EXTERN unsigned int _ignore_end_points;
EXTERN double _vague_range_margin;
EXTERN double _point_spacing_sigma_factor;
EXTERN int _spacing_npoints;
EXTERN double _max_disoriented_pos_noise_elongation;
EXTERN double _max_acceleration;
EXTERN double _max_jerk;
EXTERN double _max_angular_acceleration;
EXTERN double _initial_d_dt_sigmas_per_sec;
EXTERN double _angle_reset_threshold;
EXTERN double _residue_time_constant;
EXTERN double _residue_mean_reset_threshold;
EXTERN float _range_limit;
EXTERN float _no_return_range;
EXTERN double _max_segment_distance;
EXTERN double _max_associate_sigmas;
EXTERN double _feature_reset_sigmas;
EXTERN double _min_associate_closeness;
EXTERN double _overlap_margin;
EXTERN double _min_info_increment;
EXTERN int _min_associate_count;
EXTERN double _max_no_associate_time;
EXTERN double _occluded_max_no_associate_time;
EXTERN double _min_no_associate_time;
EXTERN int _min_track_points;
EXTERN unsigned int _history_size;
EXTERN double _history_predict_interval;
EXTERN double _history_measure_interval;
EXTERN double _history_measure_fraction;
EXTERN unsigned int _max_validate;
EXTERN double _min_invalid_history_distance;
EXTERN double _max_valid_history_distance;
EXTERN double _max_v_correction_history_distance;
EXTERN double _max_v_correction;
EXTERN double _history_moving_factor;
EXTERN double _history_unknown_factor;
EXTERN double _history_bad_v_factor;
EXTERN double _min_history_pos_info;
EXTERN double _history_outlier_sigmas;
EXTERN double _max_invalid_velocity_deviation;
EXTERN double _max_valid_velocity_deviation;
EXTERN double _max_fixed_velocity;
EXTERN double _min_moving_velocity;
EXTERN double _min_moving_sigmas;
EXTERN double _max_fixed_sigmas;
EXTERN double _back_time_ignore;
EXTERN double _back_time_discard;
EXTERN double _max_dropout_size;
EXTERN double _max_occlusion_size;
EXTERN double _max_hole_size;
EXTERN double _max_step_size;
EXTERN int _max_segment_set_size;

EXTERN bool _detect_occlusion;
EXTERN bool _use_velocity_correction;
EXTERN bool _use_bounding_box;
EXTERN bool _model_based_segmentation;
EXTERN int _max_segment_iterations;

EXTERN bool _render_tracks;
EXTERN bool _show_early_tracks;
EXTERN bool _show_ignored_points;
EXTERN bool _render_verbose;

EXTERN bool _print_moving_tracks;
EXTERN bool _print_died_without_descendents;
EXTERN int _float_exception_mode;

EXTERN unsigned int _validate_trace_track;
EXTERN double _validate_trace_time;
EXTERN float _line_width;
EXTERN double _point_depth;
EXTERN int _font_size;
EXTERN bool _render_points_only;
EXTERN double _path_interval;
EXTERN unsigned int _path_size;  // rint(path_duration/path_interval)
EXTERN bool _path_incremental_motion;

EXTERN bool _black_background;

EXTERN const char *_log_format;
EXTERN bool _tracklogger_configured;
EXTERN bool _pointlogger_configured;

void init_params (ConfigSource *config);

#endif
