#include "utils/ConfigFile.h"
#include <math.h>
#include "TrackLogger.h"
#include "PointLogger.h"

#define EXTERN
#include "params.h"

// Initialize static parameter caches.
void init_params (ConfigSource *config) {
  _max_scan_size = config->getInt("max_scan_size");
  _pos_noise = config->getDouble("pos_noise");
  _disoriented_pos_noise = config->getDouble("disoriented_pos_noise");
  _vague_pos_noise = config->getDouble("vague_pos_noise");
  _occluded_noise_factor = config->getDouble("occluded_noise_factor");
  _min_noise_factor = config->getDouble("min_noise_factor");
  _angular_pos_noise = config->getDouble("angular_pos_noise") * M_PI/180;
  _velocity_angular_pos_noise
    = config->getDouble("velocity_angular_pos_noise") * M_PI/180;
  _initial_velocity_noise = config->getDouble("initial_velocity_noise");
  _initial_acceleration_noise = config->getDouble("initial_acceleration_noise");
  _initial_angular_velocity_noise
    = config->getDouble("initial_angular_velocity_noise") * M_PI/180;
  _line_tolerance = config->getDouble("line_tolerance");
  _disoriented_line_tolerance = config->getDouble("disoriented_line_tolerance");
  _line_discard_fraction = config->getDouble("line_discard_fraction");
  _corner_weight = config->getDouble("corner_weight");
  _cos_fit_big_difference = cos(config->getDouble("fit_big_difference") * M_PI/180);
  _fit_much_better = config->getDouble("fit_much_better");
  _compact_size = config->getDouble("compact_size");
  _compact_min_density = config->getDouble("compact_min_density");
  _vague_range_margin = config->getDouble("vague_range_margin");
  _point_spacing_sigma_factor = config->getDouble("point_spacing_sigma_factor");
  _spacing_npoints = config->getInt("spacing_npoints");
  _max_disoriented_pos_noise_elongation = config->getDouble("max_disoriented_pos_noise_elongation");
  _min_segment_points = config->getInt("min_segment_points");
  _ignore_end_points = config->getInt("ignore_end_points");
  _linear_size = config->getDouble("linear_size");
  _cos_min_corner_angle = cos(config->getDouble("min_corner_angle")*M_PI/180);
  _min_line_points = config->getInt("min_line_points");
  _max_acceleration = config->getDouble("max_acceleration");
  _max_jerk = config->getDouble("max_jerk");
  _max_angular_acceleration
    = config->getDouble("max_angular_acceleration") * M_PI/180;
  _initial_d_dt_sigmas_per_sec = config->getDouble("initial_d_dt_sigmas_per_sec");
  _angle_reset_threshold
    = config->getDouble("angle_reset_threshold") * M_PI/180;
  _residue_time_constant = config->getDouble("residue_time_constant");
  _residue_mean_reset_threshold = config->getDouble("residue_mean_reset_threshold");
  _range_limit = config->getFloat("range_limit");
  _no_return_range = config->getFloat("no_return_range");
  _max_segment_distance = config->getDouble("max_segment_distance");
  _overlap_margin = config->getDouble("overlap_margin");
  _max_associate_sigmas = config->getDouble("max_associate_sigmas");
  _feature_reset_sigmas = config->getDouble("feature_reset_sigmas");
  _min_associate_closeness = config->getDouble("min_associate_closeness");
  _min_info_increment = config->getDouble("min_info_increment");
  _min_associate_count = config->getInt("min_associate_count");
  _min_no_associate_time = config->getDouble("min_no_associate_time");
  _max_no_associate_time = config->getDouble("max_no_associate_time");
  _occluded_max_no_associate_time = config->getDouble("occluded_max_no_associate_time");
  _render_tracks = config->getBool("render_tracks", true);
  _render_verbose = config->getBool("render_verbose", false);
  _show_early_tracks = config->getBool("show_early_tracks");
  _show_ignored_points = config->getBool("show_ignored_points");

  _print_moving_tracks = config->getBool("print_moving_tracks");
  _print_died_without_descendents =
    config->getBool("print_died_without_descendents");
  _line_width = config->getFloat("line_width", 1.0);
  _point_depth = config->getFloat("point_depth", 0.03);
  _font_size = config->getInt("font_size", 8);
  _render_points_only = config->getBool("render_points_only", false);
  _black_background = config->getBool("black_background", true);
  _validate_trace_track = config->getInt("validate_trace_track");
  _validate_trace_time = config->getDouble("validate_trace_time");
  _min_track_points = config->getInt("min_track_points");
  _history_size = config->getInt("history_size");
  _history_predict_interval = config->getDouble("history_predict_interval");
  _history_measure_interval = config->getDouble("history_measure_interval");
  _history_measure_fraction = config->getDouble("history_measure_fraction");
  _max_validate = config->getInt("max_validate");
  _min_invalid_history_distance = config->getDouble("min_invalid_history_distance");
  _max_valid_history_distance = config->getDouble("max_valid_history_distance");
  _max_v_correction_history_distance =
    config->getDouble("max_v_correction_history_distance");
  _max_v_correction = config->getDouble("max_v_correction");
  _history_moving_factor = config->getDouble("history_moving_factor");
  _history_unknown_factor = config->getDouble("history_unknown_factor");
  _history_bad_v_factor = config->getDouble("history_bad_v_factor");
  _min_history_pos_info = config->getDouble("min_history_pos_info");
  _history_outlier_sigmas = config->getDouble("history_outlier_sigmas");
  _max_invalid_velocity_deviation = config->getDouble("max_invalid_velocity_deviation");
  _max_valid_velocity_deviation = config->getDouble("max_valid_velocity_deviation");
  _max_fixed_velocity = config->getDouble("max_fixed_velocity");
  _min_moving_velocity = config->getDouble("min_moving_velocity");
  _min_moving_sigmas = config->getDouble("min_moving_sigmas");
  _max_fixed_sigmas = config->getDouble("max_fixed_sigmas");
  _process_position_noise = config->getDouble("process_position_noise");
  _process_velocity_noise = config->getDouble("process_velocity_noise");
  _process_acceleration_noise = config->getDouble("process_acceleration_noise");
  _process_angular_position_noise
    = config->getDouble("process_angular_position_noise") * M_PI/180;
  _process_angular_velocity_noise
    = config->getDouble("process_angular_velocity_noise") * M_PI/180;
  _log_format = config->getString("log_format");
  _back_time_ignore = config->getDouble("back_time_ignore");
  _back_time_discard = config->getDouble("back_time_discard");

  _detect_occlusion = config->getBool("detect_occlusion");
  _use_velocity_correction = config->getBool("use_velocity_correction");
  _use_bounding_box = config->getBool("use_bounding_box");
  _model_based_segmentation = config->getBool("model_based_segmentation");
  _max_segment_iterations = config->getInt("max_segment_iterations");
  _max_dropout_size = config->getDouble("max_dropout_size");
  _max_occlusion_size = config->getDouble("max_occlusion_size");
  _max_hole_size = config->getDouble("max_hole_size");
  _max_step_size = config->getDouble("max_step_size");
  _max_segment_set_size = config->getInt("max_segment_set_size");

  _float_exception_mode = config->getInt("float_exception_mode");

  _path_interval = config->getDouble("path_interval", 1);
  _path_size = (unsigned int)rint(config->getDouble("path_duration")
				  / _path_interval);
  _path_incremental_motion = config->getBool("path_incremental_motion");

  const char *tl_spec = config->getString("logger_spec");
  if (tl_spec && tl_spec[0]) {
    _tracklogger_configured = true;
    ConfigFile cf;
    cf.parse(tl_spec);
    TrackLogger::static_init(&cf);
  } else {
    _tracklogger_configured = false;
  }

  const char *pl_spec = config->getString("point_logger_spec");
  if (pl_spec && pl_spec[0]) {
    _pointlogger_configured = true;
    ConfigFile cf;
    cf.parse(pl_spec);
    PointLogger::static_init(&cf);
  } else {
    _pointlogger_configured = false;
  }
}
