function [] = hist_speed(data, use_corr, style)
global v_x_col v_y_col valid_col v_x_correction_col v_y_correction_col
val_ix = data(:,valid_col) == 1;
%val_ix = data(:,valid_col) >=0 ; % all data
xs = data(val_ix,v_x_col);
ys = data(val_ix,v_y_col);
if (use_corr)
 xs = xs + data(val_ix,v_y_correction_col);
 ys = ys + data(val_ix,v_y_correction_col);
end

speed = sqrt(xs.^2 + ys.^2);
speed = speed(speed < 10);

[n,xout]=hist(speed,60);
semilogy(xout, n ./ size(speed, 1), style);

xlabel('speed (meters/sec)');
ylabel('normalized frequency');
