function [res] = hist_data(tracks)
global data_size;
nrec = 0;

% drop this many leading records on each track to allow the filter to
% settle. 
num_drop = 25;

for tk_ix = 1:length(tracks)
  tk = tracks{tk_ix};
  tk_num = size(tk,1) - num_drop;
  if (tk_num > 0)
    nrec = nrec + tk_num;
  end
end

fprintf(1, 'Total records %d.\n', nrec);

res = zeros(nrec, data_size);
ix = 1;

for tk_ix = 1:length(tracks)
  tk = tracks{tk_ix};
  tk_num = size(tk,1) - num_drop;
  if (tk_num > 0) 
    res(ix:(ix+tk_num-1),:) = tk(num_drop+1:end,:);
    ix = ix + tk_num;
  end
end

