global data_dir
%data_dir = '../log/';
files = dir([data_dir '*.test']);
%files = files(1:100);

global id_col;
global time_col;
global shape_class_col;
global disoriented_col;
global compact_col;
global limiting_dv_dt_col;
global valid_col;
global moving_col;
global do_validate_col;
global associated_count_col;
global split_from_col;
global living_offspring_col;
global merged_with_col;
global pos_x_col;
global pos_y_col;
global v_x_col;
global v_y_col;
global v_x_correction_col;
global v_y_correction_col;
global a_x_col;
global a_y_col;
global theta_col;
global v_theta_col;
global min_02_col;
global min_05_col;
global min_10_col;
global min_20_col;
global min_50_col;
global rms_02_col;
global rms_05_col;
global rms_10_col;
global rms_20_col;
global rms_50_col;
global data_size;

id_col = 1;
time_col = 2;
shape_class_col = 3;
disoriented_col = 4;
compact_col = 5;
limiting_dv_dt_col = 6;
valid_col = 7;
moving_col = 8;
do_validate_col = 9;
associated_count_col = 10;
split_from_col = 11;
living_offspring_col = 12;
merged_with_col = 13;
pos_x_col = 14;
pos_y_col = 15;
v_x_col = 16;
v_y_col = 17;
v_x_correction_col = 18;
v_y_correction_col = 19;
a_x_col = 20;
a_y_col = 21;
theta_col = 22;
v_theta_col = 23;
min_02_col = 24;
rms_02_col = 25;
min_05_col = 26;
rms_05_col = 27;
min_10_col = 28;
rms_10_col = 29;
min_20_col = 30;
rms_20_col = 31;
min_50_col = 32;
rms_50_col = 33;
data_size = 33;

% classified tracks are represented as cell vectors of the data for
% the individual tracks.
do_valid_data = {};
moving_data = {};
fixed_data = {};
unknown_data = {};

for f_ix = 1:length(files)
  fname = [data_dir files(f_ix).name];
  [data,data_num] = loadone(fname);
  if (data_size ~= data_size) 
    fprintf(1, 'Bad data size: %d for %s, ignoring...\n', ...
           data_size, fname);
  else
    sdata = sum(data,1);
    if (sdata(moving_col))
      moving_data{length(moving_data)+1} = data;
    else
      if (sdata(valid_col))
        fixed_data{length(fixed_data)+1} = data;
      else 
        unknown_data{length(unknown_data)+1} = data;
      end
    end
    if (sdata(do_validate_col))
      do_valid_data{length(do_valid_data)+1} = data;
    end
  end
end

fprintf(1, 'do_valid %d, moving %d, fixed %d, unknown %d\n', ...
	length(do_valid_data), length(moving_data), ...
	length(fixed_data), length(unknown_data));
