#ifndef _DISPLAY_DEMO_GUI_H
#define _DISPLAY_DEMO_GUI_H
#include <Display/Display.h>
#include <Fl/Fl_Double_Window.h>
#include <Fl/Fl_Check_Button.h>


/*
 * This is code to embed the display window into a larger GUI. 
 * If you just want to display, the display window can be made
 * top level (you just need to ->show() it)
 */

class Gui : public Fl_Double_Window
{
 public:
	Gui(Display *disp,
            int w, int h, const char *name);
	virtual ~Gui();
	
	virtual void resize(int, int, int, int);
	

	Display     *_disp;

 private:
	static void _window_callback(Fl_Widget *widget, void *arg);
	static void _verbose_callback(Fl_Widget *widget, void *arg);
	static void _points_only_callback(Fl_Widget *widget, void *arg);
	static void _track_veh_pos_callback(Fl_Widget *widget, void *arg);
	static void _track_veh_rot_callback(Fl_Widget *widget, void *arg);

	Fl_Check_Button         _verbose;
	Fl_Check_Button         _points_only;
	Fl_Check_Button         _track_veh_pos;
	Fl_Check_Button         _track_veh_rot;
};

#endif
