#include "gui.h"
#include "params.h"

Gui::Gui(Display *disp,
         int width, int height, const char *name)
	:Fl_Double_Window(width, height, name),
	_disp(disp),
	_verbose(0, 0, 200, 20, "Display Verbose"),
	_points_only(0, 0, 200, 20, "Display Points Only"),
	_track_veh_pos(0, 0, 200, 20, "Track Vehicle Position"),
	 _track_veh_rot(0, 0, 200, 20, "Track Vehicle Rotation")
{
	callback(Gui::_window_callback, 0);
	Fl_Window::size_range(500, 300);
	_verbose.callback(Gui::_verbose_callback, _disp);
	_points_only.callback(Gui::_points_only_callback, _disp);
	_track_veh_pos.callback(Gui::_track_veh_pos_callback, _disp);
	_track_veh_rot.callback(Gui::_track_veh_rot_callback, _disp);
	end();

	/*
	 * Set up the check buttons to be the starting state, as determined
	 * by the config file
	 */
	_verbose.value(_render_verbose);
	_points_only.value(_render_points_only);
	_track_veh_pos.value(_disp->is_tracking_veh_pos());
	_track_veh_rot.value(_disp->is_tracking_veh_rot());

#if 1
        /*
	 * My impression is that FLTK should do this automatically to disp
	 * when you ->show() this widget, since _disp is now a child.  But
	 * that doesn't seem to work...
	 */
        add(_disp);
//	_disp->set_visible();
//        _disp->show();
#endif
}

Gui::~Gui() 
{
}

void Gui::resize(int new_x, int new_y, int new_w, int new_h)
{
	_disp->resize(0, 0, new_w, new_h - 60);
	_verbose.position(10, new_h - 40);
	_points_only.position(10, new_h - 20);
	_track_veh_pos.position(210, new_h - 40);
	_track_veh_rot.position(210, new_h - 20);
	Fl_Double_Window::resize(new_x, new_y, new_w, new_h);
} 

void Gui::_verbose_callback(Fl_Widget *widget, void *arg)
{
  _render_verbose = ((Fl_Check_Button *)widget)->value();
}

void Gui::_points_only_callback(Fl_Widget *widget, void *arg)
{
  _render_points_only = ((Fl_Check_Button *)widget)->value();
}

void Gui::_track_veh_pos_callback(Fl_Widget *widget, void *arg)
{
	((Display *)arg)->track_veh_pos(((Fl_Check_Button *)widget)->value());
}

void Gui::_track_veh_rot_callback(Fl_Widget *widget, void *arg)
{
	((Display *)arg)->track_veh_rot(((Fl_Check_Button *)widget)->value());
}

void Gui::_window_callback(Fl_Widget *widget, void *arg)
{
	exit(0);
}
