#ifndef FLOAT_TRAP_H
#define FLOAT_TRAP_H

// Initialize float trap/exception support.
void ft_init ();

// The intention is that some operation that may cause a float exception is
// wrapped by ft_poll_before/ft_poll_after calls.  Both do basically the same
// thing, check for exceptions, and if any, print a message and clear the
// exceptions, returning true if there were any exceptions (other than
// underflow or inexact.)  before/after only affects the message, as when
// there are exceptions beforehand, the exception happened in some unknown
// place not bracketed ft_poll_XXX.
#define ft_poll_before(context) _ft_poll(__FILE__, __LINE__, "before", context)
#define ft_poll_after(context) _ft_poll(__FILE__, __LINE__, "after", context)

bool _ft_poll (char *file, int line, char *wot, char *context);

#endif
