#include <utils/Basic.h>

#ifdef HAVE_IOSTREAM

#include "utils/message.h"
#include "utils/Time.h"
#include "stdio.h"
#include "stdarg.h"

__UTILS_BEGIN_NAMESPACE
using namespace std;

void _print_time () {
  int old_prec = cerr.precision();
  cerr.precision(13);
  cerr <<Time::getTimeOfDay().getValue() <<" ";
  cerr.precision(old_prec);
}

static const int MPRINTF_MAX = 160;

void mprintf (char *file, int line, __MprintfSeverity severity, char *format,
	      ...)
{
  char buf[MPRINTF_MAX];
  va_list ap;
  va_start(ap, format);
  vsnprintf((char *)&buf, MPRINTF_MAX, format, ap);
  bool fatal = false;
  char *str;
  switch (severity) {
    case __MP_DEBUG:
      str = "debug: ";
      break;
    case __MP_NOTE:
      str = "note: ";
      break;
    case __MP_WARN:
      str = "warning: ";
      break;
    case __MP_ERROR:
      str = "error: ";
      fatal = true;
      break;
  default:
    str = "bad: ";
    fatal = true;
  }

  _print_time();
  cerr <<file <<":" <<line <<": " <<str <<buf;
  if (fatal) abort();
}

__UTILS_END_NAMESPACE

#endif

