#include <stdio.h>
#include <utils/List.h>

int seq[] = { 1, 1, 1, 1, 2, 2, 3, 4, 5, 2, 10, 6, 7, 8, 9, 10, 10 };

void print_int_list(utils::List<void>& list)
{
  void* current;
  utils::ListIterator<void> iter(list);
  for (current = iter.first(); current; current = iter.next())
    printf("%d ", (int) current);
  printf("\n");
}

main(int argc, char** argv)
{
  if (argc < 3) {
    fprintf(stderr, "Need numbers axe\n");
    exit(-1);
  }

  utils::List<void> list;
  int i;
  for (i=0;i<sizeof(seq)/sizeof(int);i++) 
    list.append((void*) seq[i]);

  print_int_list(list);

  void* current;
  int dead = atoi(argv[1]);
  utils::ListIterator<void> iter(list);
  for (current = iter.first(); current; current = iter.next())
    if ((int) current == dead)
      iter.removeCurrent();

  print_int_list(list);

  int insert_point = atoi(argv[2]);
  bool before;
  if (insert_point < 0) {
    before = true;
    insert_point = -insert_point;
  } else
    before = false;
  int insertion = atoi(argv[3]);
  for (current = iter.first(); current; current = iter.next()) {
    if ((int) current == insert_point) {
      if (before)
        iter.insertBeforeCurrent((void*) insertion);
      else
        iter.insertAfterCurrent((void*) insertion);
    }
  }

  print_int_list(list);
}

                
    
    
