///////////////////////////////////////////////////////////////////////////////
//
//                              RestrictAction.h
//
// Defines the restrict format action.  The restrict returns the most
// restrictive element in a data structure specifed by a format specifier.
// The implementation, and even whether it exists or not, depends on the
// particular machine architecture
//
// Classes defined for export:
//   RestrictAction - the restrict format action class
//
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_restrict_action_h
#define utils_restrict_action_h

#include <utils/formatting/FormatAction.h>
#include <utils/formatting/FormConfig.h>

__UTILS_BEGIN_NAMESPACE

class RestrictAction : public FormatAction {
    UTILS_BASE_HEADER(RestrictAction);
  public:
    RestrictAction();

    void resetRestriction() { _restriction = 0; }
    int getRestriction() { return _restriction; }
    void restrict(int r) { primRestrict(r); }

    virtual bool actInt() { return primRestrict(sizeof(int)); }
    virtual bool actShort() { return primRestrict(sizeof(short)); }
    virtual bool actLong() { return primRestrict(sizeof(long)); }
    virtual bool actFloat() { return primRestrict(sizeof(float)); }
    virtual bool actDouble() { return primRestrict(sizeof(double)); }
    virtual bool actChar() { return primRestrict(sizeof(char)); }
    virtual bool actString() { return primRestrict(sizeof(char*)); }

    virtual bool actLength(int size) { return primRestrict(size); }
    virtual bool actPtr(FormatSpec*) { return primRestrict(sizeof(void*));}

    virtual bool actStruct(int size, FormatSpec** elems);
    virtual bool actFixedArray(const Vector<int>&, FormatSpec* fmt);
    virtual bool actVarArray(StructSpec*, const Vector<int>&,
                             FormatSpec*);

    static void initClass();

  private:
    bool primRestrict(int size);

  private:
    int _restriction;  // the size of the most resrictive element
};

__UTILS_END_NAMESPACE

#endif



