///////////////////////////////////////////////////////////////////////////////
//
//                              ReadAction.h
//
// Defines the read format action.  The read format action gets data
// as specified by format specifiers from an FbInput
//
// Classes defined for export:
//   ReadAction - the read format action class
//
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_read_action_h
#define utils_read_action_h

#include <stdio.h>
#include <utils/formatting/DataAction.h>

__UTILS_BEGIN_NAMESPACE

class Input;

// helps out ReadAction::actVarArray by holding info necessary to defer 
// reading in an array until the indices are read
struct DeferredVarArray {
    StructSpec* parent;      // the parent structure of the var array
    const Vector<int>* indices;// the indices into parent for the dimensions
    FormatSpec* fmt;         // what the variable array contains
    int index;                 // where the variable array is
    Vector<char>* buffer;      // holds the unread string of the array 
                               // being deferred

    // dummy for Vector's find operation
    int operator ==(const DeferredVarArray&) { return false; }
};

class ReadAction : public DataAction {
    UTILS_BASE_HEADER(ReadAction);
  public:
    ReadAction(void* data = NULL);
    ReadAction(Input& input, void* data = NULL);
    virtual ~ReadAction();

    Input& getInput() const { return _input; }
    bool putData(void*, int);
   
    virtual bool actInt();
    virtual bool actShort();
    virtual bool actLong();
    virtual bool actFloat();
    virtual bool actDouble();
    virtual bool actChar();
    virtual bool actString();
    virtual bool actLength(int size);
    virtual bool startStruct();
    virtual bool endStruct();
    virtual bool actStructElem(int, int, FormatSpec**);
    virtual bool actPtr(FormatSpec* fmt);
    virtual bool actFixedArray(const Vector<int>& sizes, FormatSpec* fmt);
    virtual bool actVarArray(StructSpec* parent,
                               const Vector<int>& indices,
                               FormatSpec* fmt);

    void init();
    static bool read(FormatSpec*, Input&, void*);
    static void initClass();

  private:
    unsigned char* allocFmt(FormatSpec*);
    unsigned char* processVarArray(StructSpec*,
                                   const Vector<int>&, FormatSpec*);
    void deferVarArray(StructSpec*, const Vector<int>&, FormatSpec*);
    void finalizeVarArray(DeferredVarArray&);

  private:
    Input& _input;    // the data source
    int _cur_index;     // current index in a structure
    // Vector of variable size arrays which have been deferred
    Vector<DeferredVarArray>* _deferred_list;  
};
    
__UTILS_END_NAMESPACE

#endif

