///////////////////////////////////////////////////////////////////////////////
//
//                               PrintFormat.h
//
// Implements an action which prints a string form of a format specifier to an
// Output
//
// Classes defined for export:
//     PrintFormatAction
//     
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_print_format_action_h
#define utils_print_format_action_h

__UTILS_BEGIN_NAMESPACE

class Output;

class PrintFormatAction : public FormatAction {
    UTILS_BASE_HEADER(PrintFormatAction);
  public:
    PrintFormatAction(Output& output);

    Output& getOutput() const { return _output; }

    virtual bool actInt();
    virtual bool actShort();
    virtual bool actLong();
    virtual bool actFloat();
    virtual bool actDouble();
    virtual bool actChar();
    virtual bool actString();

    virtual bool actLength(int size);
    virtual bool actPtr(FormatSpec*);
    virtual bool actSelfPtr(StructSpec*);

    virtual bool startStruct();
    virtual bool endStruct();
    virtual bool actStructElem(int i, int size, FormatSpec** elems);

    virtual bool actFixedArray(const Vector<int>& sizes, FormatSpec* fmt);
    virtual bool actVarArray(StructSpec*,
                             const Vector<int>&, FormatSpec*);

    static bool print(FormatSpec*, Output&);
    static char* printToString(FormatSpec* spec);

    static void initClass();

  private:
    PrintFormatAction();

  private:
    Output& _output;   // the print destination
};

__UTILS_END_NAMESPACE

#endif
