///////////////////////////////////////////////////////////////////////////////
//
//                                 FormatParser.h
//
// This header file defines a class that takes a format specifying string and
// parses it into the equivalent FormatSpec internal structure.
//
// Classes defined for export:
//    FormatParser
//
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_format_parser_h
#define utils_format_parser_h

#include <utils/Basic.h>

__UTILS_BEGIN_NAMESPACE

class FormatSpec;
class StructSpec;
class TokenReader;
struct Token;
class Mutex;
template <class T> class StringDict;

/* The format parsing class */
class FormatParser {
  public:
    FormatParser(Mutex* = (Mutex*) NULL);
    ~FormatParser();

    FormatSpec* parseString(const char*);
    bool registerFormat(const char *name, FormatSpec* fmt);
    FormatSpec* parse(StructSpec*);
    TokenReader* tokenReader() const { return _reader; }
    void setErrorVerbosity(bool v) { _verbose_errors = v; }
    bool getErrorVerbosity() const { return _verbose_errors; }

  private:
    void parserError(Token*, char*);
    FormatSpec* structFormat();
    FormatSpec* fixedArrayFormat();
    FormatSpec* varArrayFormat(StructSpec*);
    FormatSpec* selfPtrFormat(StructSpec*);
    FormatSpec* ptrFormat();
    FormatSpec* lengthFormat(Token*);
    FormatSpec* namedFormat(Token*);
    FormatSpec* primitiveFormat(Token*);
    FormatSpec* specialFormat();

  private:
    TokenReader* _reader;    // the lexical analyzer for format tokens
    const char* _parse_string; // the current string we are working on
    StringDict<FormatSpec*>* _format_table;  // table of format names
    Mutex* _mutex; // semphore if you want to make a global parser threadsafe
    bool _verbose_errors;
};

__UTILS_END_NAMESPACE

#endif
