///////////////////////////////////////////////////////////////////////////////
//
//                               FormatEqualsAction.h
//
// Implements an action which determines if one formatter equals another
//
// Classes defined for export:
//     FormatEqualsAction
//     
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_format_equals_action_h
#define utils_format_equals_action_h

#include <utils/formatting/FormatAction.h>

__UTILS_BEGIN_NAMESPACE

class FormatEqualsAction : public FormatAction {
    UTILS_BASE_HEADER(FormatEqualsAction);
  public:
    FormatEqualsAction(FormatSpec* other = (FormatSpec*) NULL);

    void reset(FormatSpec* other) { _res = true; _other = other; }
    bool result() const { return _res; }
    void indicateInequality() { _res = false; }
    FormatSpec* getOther() const { return _other; }

    virtual bool actInt();
    virtual bool actShort();
    virtual bool actLong();
    virtual bool actFloat();
    virtual bool actDouble();
    virtual bool actChar();
    virtual bool actString();

    virtual bool actLength(int size);
    virtual bool actPtr(FormatSpec*);
    virtual bool actSelfPtr(StructSpec*);

    virtual bool actStruct(int size, FormatSpec** elems);

    virtual bool actFixedArray(const Vector<int>& sizes, FormatSpec* fmt);
    virtual bool actVarArray(StructSpec*,
                             const Vector<int>&, FormatSpec*);

    static bool equals(FormatSpec* one, FormatSpec* other);
    static void initClass();

  private:
    bool _res;          // the accumulated result
    FormatSpec* _other; // the other formatter being checked
};

__UTILS_END_NAMESPACE

#endif
