///////////////////////////////////////////////////////////////////////////////
//
//                               FlatAction.h
//
// Implements a format action class which determines if a format specifier
// corresponds to a "flat" data structure, i.e., one which has no other
// pointers below it
//
// Classes defined for export:
//     FlatAction
//     
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_flat_action_h
#define utils_flat_action_h

#include <utils/formatting/FormatAction.h>

__UTILS_BEGIN_NAMESPACE

class FlatAction : public FormatAction {
    UTILS_BASE_HEADER(FlatAction);
  public:
    FlatAction();

    bool isFlat() const { return _flat; }
    void setFlat(bool f) { _flat = f; }

    virtual bool actInt() { _flat = true; return true; }
    virtual bool actShort() { _flat = true; return true; }
    virtual bool actLong() { _flat = true; return true; }
    virtual bool actFloat() { _flat = true; return true; }
    virtual bool actDouble() { _flat = true; return true; }
    virtual bool actChar() { _flat = true; return true; }
    virtual bool actString() { _flat = false; return true; }

    virtual bool actLength(int) { _flat = true; return true; }
    virtual bool actPtr(FormatSpec*) { _flat = false; return true; }

    virtual bool actStruct(int size, FormatSpec** elems);
    virtual bool actFixedArray(const Vector<int>&, FormatSpec* fmt);
    virtual bool actVarArray(StructSpec*, const Vector<int>&,
                             FormatSpec*);

    static void initClass();

  private:
    bool _flat;  // stays true if whole data structure is flat
};

__UTILS_END_NAMESPACE

#endif
