///////////////////////////////////////////////////////////////////////////////
//
//                               EqualsAction.h
//
// Implements an action which determines if  one block of structured data is
// equal to another
//
// Classes defined for export:
//     EqualsAction
//     
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_equals_action_h
#define utils_equals_action_h

#include <utils/formatting/DataAction.h>

__UTILS_BEGIN_NAMESPACE

class EqualsAction : public DataAction {
    UTILS_BASE_HEADER(EqualsAction);
  public:
    EqualsAction(void* data = NULL, void* other = NULL);

    bool result() const { return _result; }
    void setResult(bool res) { _result = res; }
    const DataAction& getOther() const { return _other; }
    void advance(int size) { addSize(size); _other.addSize(size); }

    virtual bool actInt() { return checkBytes(sizeof(int)); }
    virtual bool actShort() { return checkBytes(sizeof(short)); }
    virtual bool actLong() { return checkBytes(sizeof(long)); }
    virtual bool actFloat() { return checkBytes(sizeof(float)); }
    virtual bool actDouble() { return checkBytes(sizeof(double)); }
    virtual bool actChar() { return checkBytes(sizeof(char)); }
    virtual bool actLength(int size) { return checkBytes(size); }

    virtual bool actString();
    virtual bool actPtr(FormatSpec*);

    virtual bool actStruct(int num_elems, FormatSpec** elems);
    virtual bool actFixedArray(const Vector<int>& sizes, FormatSpec* fmt);
    virtual bool actVarArray(StructSpec*,
                             const Vector<int>&, FormatSpec*);
    static bool equals(FormatSpec*, void*, void*);

    static void initClass();

  private:
    bool checkBytes(int);

  private:
    bool _result;       // accumulated result
    DataAction _other;  // the other data being checked against
};

__UTILS_END_NAMESPACE

#endif
