///////////////////////////////////////////////////////////////////////////////
//
//                               DataAction.h
//
// Implements an abstract format action class which works on data structures
//
// Classes defined for export:
//     DataAction
//     
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_data_action_h
#define utils_data_action_h

#include <utils/formatting/DataSizeAction.h>

__UTILS_BEGIN_NAMESPACE

template <class T> class List;

class DataAction : public DataSizeAction {
    UTILS_BASE_HEADER(DataAction);
  public:
    DataAction(void* data = NULL);
    virtual ~DataAction();

    void resetData(void* data) { _data = (unsigned char*) data; resetSize(); }
    unsigned char* getData() const { return _data; }
    unsigned char* getSubData() const;
    unsigned char* curData() const { return _data + getSize(); }

    virtual bool startStruct();
    virtual bool endStruct();
    int varArraySize(StructSpec* parent, int sizeIndex);
    int varArraySize(StructSpec* parent, const Vector<int>& indices);

    static void initClass();

  private:
    unsigned char* _data;          // data we are working on
    List<void>* _sizes;             // stack of indices used so we can
                                   // keep track of startStructs
};

__UTILS_END_NAMESPACE

#endif
