///////////////////////////////////////////////////////////////////////////////
//
//                               CustomPtrSpec.h
//
// This is a format specifier class which helps in defining other classes.
// It provides some common responses to some actions for any custom specifer
// that will be a pointer
// 
//
// Classes defined for export:
//   CustomPtrSpec
//
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_custom_ptr_spec_h
#define utils_custom_ptr_spec_h

#include <utils/formatting/CustomSpec.h>

__UTILS_BEGIN_NAMESPACE

class CustomPtrSpec : public CustomSpec {
    UTILS_BASE_HEADER(CustomPtrSpec);

  public:
    CustomPtrSpec();

    static void initClass();

    // all subjects of CustomPtrSpec will not be simple
    virtual bool isSimpleType() const { return false; }
};

__UTILS_END_NAMESPACE

#endif
