///////////////////////////////////////////////////////////////////////////////
//
//                               CloneAction.h
//
// Implements an action which clones data from one block structured data
// to another (i.e. copies for everything not a descendent of container, clones
// those guys)
//
// Classes defined for export:
//     CloneAction
//     
///////////////////////////////////////////////////////////////////////////////

#ifndef utils_clone_action_h
#define utils_clone_action_h

#include <utils/formatting/CopyAction.h>

__UTILS_BEGIN_NAMESPACE

class CloneAction : public CopyAction {
    UTILS_BASE_HEADER(CloneAction);
  public:
    CloneAction(void* data = NULL, void* dest = NULL);

    static bool clone(FormatSpec*, void*, void*);
    static void initClass();
};

__UTILS_END_NAMESPACE

#endif

