/***************************************************************************

                                Player.h

  Defines a class can be used to read values from a canned data file
  with formatted records.

  Classes defined for export:
    Player - the playback class

***************************************************************************/

#ifndef UTILS_PLAYER_H
#define UTILS_PLAYER_H

#include <utils/Time.h>
#include <utils/List.h>
#include <utils/StringDict.h>
#include <utils/ConfigFile.h>
#include <utils/CannedDataRead.h>
#include <utils/formatting/FormatParser.h>

__UTILS_BEGIN_NAMESPACE

class Time;
class PlayElem;

class Player {
 public:
  Player();
  ~Player();

  bool open(const char*, bool do_setup=true);
  bool setup();

  PlayElem* expect(const char* name, const char* format, void* address);
  bool get(Time& play_time);
  void first();
  bool prev();
  bool next();
  bool eof();
  void release(PlayElem*);
  void getCurTime(Time& time);
  
  int getByteOrder() const { return _byte_order; }
  int getAlignment() const { return _alignment; }

  CannedDataReader& getReader() { return _reader; }
  ConfigFile& getHeader() { return _header; }
  Time getStart();
  Time getEnd();
  void setZero(Time zero);

  bool process(Time& time);

 private:
  CannedDataReader _reader;
  FormatParser *_parser;
  List<PlayElem> _input;
  StringDict<PlayElem*> _elems;
  int _byte_order, _alignment;
  ConfigFile _header;
  int _buf_size;
  unsigned char* _buffer;
  Time _zero_time;
  Time _offset;
  Time _last_time;
};

__UTILS_END_NAMESPACE

#endif

