///////////////////////////////////////////////////////////////////////////////
//
//                               Creator.h
//
// Defines classes and templates for ultimately creating a reconfigurable
// interface
//
// Classes defined for export:
//   CreatorBase - abstract class for creating a generic reconfigurable 
//      interface
//
// Templates defined for export:
//   Creator - template for creating a specific reconfigurable interface
//
///////////////////////////////////////////////////////////////////////////////

#ifndef UTILS_CREATOR_H
#define UTILS_CREATOR_H

#include <utils/Basic.h>

__UTILS_BEGIN_NAMESPACE

class GeneratorBase;
class SymbolTable;
class ConfigFile;

class CreatorBase {
  public:
    virtual void* make(GeneratorBase*, ConfigFile*, SymbolTable*)
        { return NULL; }
};

template <class T> class Generator;
template <class T>
class Creator : public CreatorBase {
  public:
    virtual T* create(Generator<T>*, ConfigFile*, SymbolTable*) = 0;
    virtual void* make(GeneratorBase*, ConfigFile*, SymbolTable*);
};

template <class T>
inline void* Creator<T>::make(GeneratorBase* gen, ConfigFile* params,
                                     SymbolTable* globals) {
    Generator<T> g(gen);
    return (void*) create(&g, params, globals);
}

__UTILS_END_NAMESPACE

#endif
