#ifndef _CANNEDDATAREAD_H
#define _CANNEDDATAREAD_H

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
//#include <stdint.h>
#include <utils/String.h>
#include <utils/CannedDataAccess.h>

__UTILS_BEGIN_NAMESPACE

class CannedDataReader : public CannedReader { 
 public:
	CannedDataReader();
	CannedDataReader(const char *filename);
	~CannedDataReader();

        /*
         * These are specified in the base class
         */	
	void           open(const char *filename);
        void           close();
	uint64_t       getCreationTime();
	void           getVersion(uint32_t *major, uint32_t *minor);
	FILE          *getHeader();
	size_t         getHeaderSize();
        void           seek(const Time &when);
        int            seekBefore(const Time &when);
	int            eof();
	void           first();
	void           last();
	void           next();
	void           prev();
        Time           getCurTimeStamp();
        Time           getFirstTimeStamp();
        Time           getLastTimeStamp();
        int            getPrevTimeStamp(Time *time);
        int            getNextTimeStamp(Time *time);
	unsigned int   getNumRecords();

        /*
         * Legacy access methods.  These are the same as the standard interfaces,
         * but use alternate time representations.  They are deprecated, and will
         * be removed from a future version.
         */
	void seek(uint64_t secs, uint64_t usecs);
	int  seekBefore(uint64_t secs, uint64_t usecs);
	void getCurTimeStamp(uint64_t *secs, uint64_t *usecs);
	void getCurTimeStamp(CannedDataTimeStamp *stamp);
	void getFirstTimeStamp(uint64_t *secs, uint64_t *usecs);
	void getFirstTimeStamp(CannedDataTimeStamp *stamp);
	void getLastTimeStamp(uint64_t *secs, uint64_t *usecs);
	void getLastTimeStamp(CannedDataTimeStamp *stamp);
	int  getPrevTimeStamp(uint64_t *secs, uint64_t *usecs);
	int  getPrevTimeStamp(CannedDataTimeStamp *stamp);
	int  getNextTimeStamp(uint64_t *secs, uint64_t *usecs);
	int  getNextTimeStamp(CannedDataTimeStamp *stamp);

	/*
         * Other functions
         */
	
	/*
	 * Get the description of this file 
	 */
	const String &getDescription();
	
	/* 
	 * Return the filetype that we think this is 
	 */
	CannedDataType getType();
	
	/*
	 * Return a string description of the file.
	 */
	String getTypeDescription();

	/* 
	 * Return a FILE pointer pointing at the start of
	 * the current record. 
	 */
	FILE *getRecord();
	
	/*
	 * Return the size of the current record
	 */
	size_t getRecordSize();
	
 private:
        void                 _warn_deprecated() {
#if 0
                static int warned = 0;
                if (!warned) {
                        warned = 1; 
                        fprintf(stderr, "Warning: Using deprecated access method(s) to CannedDataReader class");
                }
#endif
        }

	void                 _openDataFiles(const char *filename, int count) ;
	void                 _init();
	CannedDataIndex      _index;
	Vector<FILE *>  _data_files;
	FILE                *_idx_file;
	String               _desc;
	CannedDataType       _type;
	long                 _header_offset;
	size_t               _header_size;          
	uint32_t             _major_version;
	uint32_t             _minor_version;
	uint32_t             _id;
	uint64_t             _creation_time;
	static char *        _type_descriptions[];
};

__UTILS_END_NAMESPACE

#endif
