#ifndef _CANNEDDATAINDEX_H
#define _CANNEDDATAINDEX_H

#include <utils/Vector.h>

#include <utils/CannedDataAccess.h>

__UTILS_BEGIN_NAMESPACE

class CannedDataIndex
{
 public:
	CannedDataIndex               ();
	~CannedDataIndex              ();
	void                first     ();
	void                last      ();
	void                next      ();
	void                previous  ();
	CannedDataIdxRecord current   ();
	void                seek      (uint64_t secs, uint64_t usecs);
	int                 seekBefore(uint64_t secs, uint64_t usecs);
	void                add       (const CannedDataIdxRecord &data);
	int                 atEnd     ();
	int                 atStart   ();
	int                 size      ();
	int                 getPos    ();
	void                setPos    (int pos);
 private:
	unsigned int _cur;
	Vector<CannedDataIdxRecord> _data;
};

__UTILS_END_NAMESPACE

#endif
