/***************************************************************************

                                Basic.h
  
 Includes many of the basics necessary to use the utils library.

 Includes the utils_config.h header file generated by configure script

***************************************************************************/

#ifndef utils_basic_h
#define utils_basic_h

#include <stdlib.h>

#include <utils_config.h>

/* This uses the preprocessor to quote a string */
#if defined(__STDC__) || defined(__ANSI_CPP__)		/* ANSI C */
#  define UTILS__QUOTE(str)	#str
#else							/* Non-ANSI C */
#  define UTILS__QUOTE(str)	"str"
#endif

/* This uses the preprocessor to concatenate two strings */
#if defined(__STDC__) || defined(__ANSI_CPP__)		/* ANSI C */
#   define UTILS__CONCAT(str1, str2)	str1##str2
#else							/* Non-ANSI C */
#   define UTILS__CONCAT(str1, str2)	str1/**/str2
#endif

/* This uses the preprocessor to concatenate three strings */
#if defined(__STDC__) || defined(__ANSI_CPP__)		/* ANSI C */
#   define UTILS__CONCAT3(str1, str2, str3)	str1##str2##str3
#else							/* Non-ANSI C */
#   define UTILS__CONCAT3(str1, str2, str3)	str1/**/str2/**/str3
#endif

#ifndef NULL
#define NULL (0L)
#endif

#if defined(HAVE_NAMESPACES)
#  define __UTILS utils
#  define __UTILS_BEGIN_NAMESPACE namespace utils {
#  define __UTILS_END_NAMESPACE }
#else
#  define __UTILS 
#  define __UTILS_BEGIN_NAMESPACE 
#  define __UTILS_END_NAMESPACE 
#endif

#ifndef __cplusplus
#undef HAVE_BOOL
#endif

#ifdef HAVE_VXWORKS_H
#define VXWORKS 1
#endif

#ifndef HAVE_BOOL
#define true 1
#define false 0
typedef unsigned int bool;
#endif

#ifndef MAX
#define MAX(a,b) ((a)>(b) ? (a):(b))
#endif

#ifndef MIN
#define MIN(a,b) ((a)<(b) ? (a):(b))
#endif

#ifndef SGN
#define SGN(x) ((x)>=0?1:-1)
#endif

#endif



