/***************************************************************************

                                BaseSub.h
  
 Defines macros to make definition of subclasses of Base easier.

***************************************************************************/

#ifndef UTILS_BASE_SUB_H
#define UTILS_BASE_SUB_H

#include <utils/Base.h>

////////////////////////////////////////////
//
// These define type-identifier and naming variables and methods that
// all subclasses and abstract subclasses must support.
//

#define UTILS_BASE_ABSTRACT_HEADER(className)                                  \
  public:                                                                     \
    static __UTILS::Type       getClassTypeId();       /* Returns class type id */   \
    virtual __UTILS::Type      getTypeId() const;      /* Returns type id      */    \
  private:                                                                    \
    static short       _class_type_id         /* Type id              */    

#define UTILS_BASE_HEADER(className) \
    UTILS_BASE_ABSTRACT_HEADER(className) ; \
	static void* createInstance(__UTILS::Name, void*)

// should be called from within initClass(). The parentClass argument
// should be the class that this subclass is derived from.
//

#define UTILS_BASE_INIT_CLASS(className, classPrint,parentPrintClass)      \
    if (_class_type_id == 0) \
        _class_type_id =                                                      \
            __UTILS::Type::createType(__UTILS::Type::fromName(parentPrintClass),            \
                        classPrint, &className::createInstance).getKey()

#define UTILS_BASE_INIT_ABSTRACT_CLASS(className, classPrint, parentPrintClass) \
    if (_class_type_id == 0) \
        _class_type_id =                                                      \
            __UTILS::Type::createType(__UTILS::Type::fromName(parentPrintClass),            \
                               classPrint).getKey()

/////////////////////////////////////////////////////////////////////////////
//
// Macros to be called within the source file for a __UTILS::Base subclass:
//

////////////////////////////////////////////
//
// This declares the static variables defined in UTILS_BASE_HEADER
// or UTILS_BASE_ABSTRACT_HEADER.
//

#define UTILS__BASE_ABSTRACT_VARS(className)                                   \
    short              className::_class_type_id = 0

//
// Non-abstract classes have all the stuff abstract classes do
//
#define UTILS__BASE_VARS(className)                                              \
    UTILS__BASE_ABSTRACT_VARS(className)

////////////////////////////////////////////
//
// Methods on the abstract type
//

#define UTILS__BASE_ABSTRACT_METHODS(className)                                \
                                                                              \
    __UTILS::Type                                                                    \
    className::getTypeId() const                                              \
    {                                                                         \
        return __UTILS::Type(_class_type_id);                                        \
    }  \
    __UTILS::Type                                                                    \
    className::getClassTypeId()                                               \
    {                                                                         \
        return __UTILS::Type(_class_type_id);                                        \
    }

////////////////////////////////////////////
//
// These implement the methods defined in UTILS_BASE_HEADER or
// UTILS_BASE_ABSTRACT_HEADER.
//

#define UTILS__BASE_METHODS(className)                                         \
                                                                              \
    UTILS__BASE_ABSTRACT_METHODS(className)                                    \
                                                                              \
    void *                                                                    \
    className::createInstance(__UTILS::Name, void*)                                  \
    {                                                                         \
        return (void *)(new className);                                       \
    }

#define UTILS__INITIALIZER(className) UTILS__CONCAT(className,Initializer)

#define UTILS__INITIALIZER_SOURCE(className) \
class UTILS__INITIALIZER(className) { \
  public: \
    UTILS__INITIALIZER(className)() { className::initClass(); } \
}

/////////////////////////////////////////////
//
// These include all the definitions required
// at file scope
//

#define UTILS_BASE_SOURCE(className)                                           \
    UTILS__INITIALIZER_SOURCE(className); \
    UTILS__BASE_VARS(className);                                               \
    UTILS__BASE_METHODS(className)

#define UTILS_BASE_ABSTRACT_SOURCE(className)                                  \
    UTILS__INITIALIZER_SOURCE(className); \
    UTILS__BASE_ABSTRACT_VARS(className);                                      \
    UTILS__BASE_ABSTRACT_METHODS(className)


///////////////////////////////////////////////
//
// This is included at the beginning of
// a constructor, to do required initializations
//

#define UTILS_BASE_CONSTRUCTOR(className)                                      \
    static UTILS__INITIALIZER(className) initializer

#endif
